/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.crypto.BC;
import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.EgkP12;
import de.gematik.bbriccs.smartcards.Hba;
import de.gematik.bbriccs.smartcards.HbaP12;
import de.gematik.bbriccs.smartcards.InstituteSmartcard;
import de.gematik.bbriccs.smartcards.Smartcard;
import de.gematik.bbriccs.smartcards.SmartcardFactory;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.SmcB;
import de.gematik.bbriccs.smartcards.SmcBP12;
import de.gematik.bbriccs.smartcards.cfg.SmartcardConfigDto;
import de.gematik.bbriccs.smartcards.exceptions.CardNotFoundException;
import de.gematik.bbriccs.smartcards.exceptions.InvalidSmartcardTypeException;
import jakarta.annotation.Nullable;
import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartcardArchive {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmartcardArchive.class);
    private static final Map<File, SmartcardArchive> ARCHIVE_CACHE = new HashMap<File, SmartcardArchive>();
    @Nullable
    private static SmartcardArchive defaultArchive = null;
    private final SmartcardFactory factory;
    private final Map<String, SmcB> smcbCache;
    private final Map<String, Hba> hbaCache;
    private final Map<String, Egk> egkCache;

    private SmartcardArchive(SmartcardFactory factory) {
        this.factory = factory;
        this.smcbCache = new HashMap<String, SmcB>();
        this.hbaCache = new HashMap<String, Hba>();
        this.egkCache = new HashMap<String, Egk>();
    }

    public static SmartcardArchive fromResources() {
        if (defaultArchive == null) {
            SmartcardFactory factory = SmartcardFactory.fromResources();
            defaultArchive = new SmartcardArchive(factory);
        }
        return defaultArchive;
    }

    public static SmartcardArchive from(String path) {
        return SmartcardArchive.from(Path.of(path, new String[0]).toFile());
    }

    public static SmartcardArchive from(File archiveFile) {
        return ARCHIVE_CACHE.computeIfAbsent(archiveFile, file -> {
            SmartcardFactory factory = SmartcardFactory.fromFileSystem(file);
            return new SmartcardArchive(factory);
        });
    }

    public List<SmartcardConfigDto> getConfigs() {
        return this.factory.getConfigs();
    }

    public List<SmartcardConfigDto> getConfigsFor(SmartcardType type) {
        return this.factory.getConfigsFor(type);
    }

    public List<String> getICCSNsFor(SmartcardType type) {
        return this.factory.getConfigsFor(type).stream().map(SmartcardConfigDto::getIccsn).toList();
    }

    public <T extends Smartcard> T getByICCSN(Class<T> classType, String iccsn) {
        if (SmcB.class.isAssignableFrom(classType)) {
            return (T)((Smartcard)classType.cast(this.getSmcbByICCSN(iccsn)));
        }
        if (Hba.class.isAssignableFrom(classType)) {
            return (T)((Smartcard)classType.cast(this.getHbaByICCSN(iccsn)));
        }
        if (Egk.class.isAssignableFrom(classType)) {
            return (T)((Smartcard)classType.cast(this.getEgkByICCSN(iccsn)));
        }
        if (InstituteSmartcard.class.isAssignableFrom(classType)) {
            return (T)((Smartcard)classType.cast(this.getByICCSN(iccsn).orElseThrow(() -> new CardNotFoundException(classType, iccsn))));
        }
        Smartcard smartcard = this.getByICCSN(iccsn).orElseThrow(() -> new CardNotFoundException(classType, iccsn));
        try {
            return (T)((Smartcard)classType.cast(smartcard));
        }
        catch (ClassCastException cce) {
            log.error(MessageFormat.format("Unable to cast Smartcard {0}", smartcard.getIccsn()), (Throwable)cce);
            throw new InvalidSmartcardTypeException(classType.getSimpleName());
        }
    }

    public Smartcard getSmartcardByICCSN(SmartcardType type, String iccsn) {
        return switch (type) {
            case SmartcardType.SMC_B -> this.getSmcbByICCSN(iccsn);
            case SmartcardType.HBA -> this.getHbaByICCSN(iccsn);
            case SmartcardType.EGK -> this.getEgkByICCSN(iccsn);
            default -> throw new InvalidSmartcardTypeException(type);
        };
    }

    public Optional<Smartcard> getByICCSN(String iccsn) {
        return this.getConfigs().stream().filter(cfg -> cfg.getIccsn().equals(iccsn)).findFirst().map(cit -> this.getSmartcardByICCSN(cit.getType(), iccsn));
    }

    public Hba getHba(int idx) {
        SmartcardConfigDto hbaConfig = this.factory.getConfigFor(SmartcardType.HBA, idx);
        return this.getHbaByICCSN(hbaConfig.getIccsn());
    }

    public Hba getHbaByICCSN(String iccsn) {
        return this.hbaCache.computeIfAbsent(iccsn, key -> this.factory.loadSmartcardByIccsn(HbaP12.class, iccsn));
    }

    public List<Hba> getHbaCards() {
        return this.getConfigsFor(SmartcardType.HBA).stream().map(c -> this.getHbaByICCSN(c.getIccsn())).toList();
    }

    public SmcB getSmcB(int idx) {
        SmartcardConfigDto smcbConfig = this.factory.getConfigFor(SmartcardType.SMC_B, idx);
        return this.getSmcbByICCSN(smcbConfig.getIccsn());
    }

    public SmcB getSmcbByICCSN(String iccsn) {
        return this.smcbCache.computeIfAbsent(iccsn, key -> this.factory.loadSmartcardByIccsn(SmcBP12.class, iccsn));
    }

    public List<SmcB> getSmcbCards() {
        return this.getConfigsFor(SmartcardType.SMC_B).stream().map(c -> this.getSmcbByICCSN(c.getIccsn())).toList();
    }

    public Egk getEgk(int idx) {
        SmartcardConfigDto egkConfig = this.factory.getConfigFor(SmartcardType.EGK, idx);
        return this.getEgkByICCSN(egkConfig.getIccsn());
    }

    public Egk getEgkByICCSN(String iccsn) {
        return this.egkCache.computeIfAbsent(iccsn, key -> this.factory.loadSmartcardByIccsn(EgkP12.class, iccsn));
    }

    public Egk getEgkByKvnr(String kvnr) {
        return this.egkCache.values().stream().filter(egk -> egk.getKvnr().equals(kvnr)).findFirst().orElseGet(() -> {
            Egk egk = this.factory.loadEgkByKvnr(kvnr);
            this.egkCache.put(egk.getIccsn(), egk);
            return egk;
        });
    }

    public List<Egk> getEgkCards() {
        return this.getConfigsFor(SmartcardType.EGK).stream().map(c -> this.getEgkByICCSN(c.getIccsn())).toList();
    }

    static {
        BC.init();
    }
}

