/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.crypto.certificate.Oid;
import de.gematik.bbriccs.smartcards.Hba;
import de.gematik.bbriccs.smartcards.InstituteSmartcardP12;
import de.gematik.bbriccs.smartcards.Smartcard;
import de.gematik.bbriccs.smartcards.SmartcardCertificate;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.cfg.SmartcardConfigDto;
import de.gematik.bbriccs.smartcards.exceptions.SmartCardKeyNotFoundException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbaP12
extends InstituteSmartcardP12
implements Hba {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HbaP12.class);

    public HbaP12(SmartcardConfigDto config, List<SmartcardCertificate> certificates) {
        super(SmartcardType.HBA, config, certificates);
    }

    public SmartcardCertificate getQesCertificate(CryptoSystem cryptoSystem) {
        return this.getKey(Oid.OID_HBA_QES, cryptoSystem).orElseThrow(() -> new SmartCardKeyNotFoundException((Smartcard)this, Oid.OID_HBA_QES, cryptoSystem));
    }

    public List<Oid> getAutOids() {
        return List.of(Oid.OID_HBA_AUT);
    }

    public Oid getEncOid() {
        return Oid.OID_HBA_ENC;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HbaP12)) {
            return false;
        }
        HbaP12 other = (HbaP12)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HbaP12;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

