/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.crypto.certificate.Oid;
import de.gematik.bbriccs.crypto.certificate.X509CertificateWrapper;
import de.gematik.bbriccs.smartcards.KeystoreType;
import de.gematik.bbriccs.smartcards.SmartcardCertificate;
import de.gematik.bbriccs.smartcards.exceptions.InvalidCertificateException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartcardCertificateP12
implements SmartcardCertificate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmartcardCertificateP12.class);
    private final Supplier<InputStream> certificateStreamSupplier;
    private final X509CertificateWrapper certWrapper;
    private final PrivateKey privateKey;
    private final CryptoSystem cryptoSystem;

    public SmartcardCertificateP12(String filePath, Supplier<InputStream> certificateStreamSupplier) {
        try (InputStream is = certificateStreamSupplier.get();){
            KeyStore.PrivateKeyEntry privateKeyEntry = this.loadEntryFromKeystore(is);
            this.certificateStreamSupplier = certificateStreamSupplier;
            this.privateKey = privateKeyEntry.getPrivateKey();
            this.certWrapper = new X509CertificateWrapper((X509Certificate)privateKeyEntry.getCertificate());
            this.cryptoSystem = CryptoSystem.fromOid((ASN1ObjectIdentifier)this.certWrapper.toCertificateHolder().getSignatureAlgorithm().getAlgorithm());
        }
        catch (Throwable t) {
            throw new InvalidCertificateException(MessageFormat.format("Something bad happened while loading the certificate from {0}\n{1}", filePath, t.getMessage()), t);
        }
    }

    public X509Certificate getX509Certificate() {
        return this.certWrapper.toCertificate();
    }

    public X509CertificateHolder getX509CertificateHolder() {
        return this.certWrapper.toCertificateHolder();
    }

    public Oid getOid() {
        Optional oid = this.certWrapper.getCertificateTypeOid();
        return (Oid)oid.orElseThrow(() -> new InvalidCertificateException(this.certWrapper));
    }

    public Supplier<InputStream> getCertificateStream() {
        return this.certificateStreamSupplier;
    }

    private KeyStore.PrivateKeyEntry loadEntryFromKeystore(InputStream is) {
        KeyStore ks = KeyStore.getInstance(KeystoreType.P12.getName());
        ks.load(is, this.getP12KeyStorePassword());
        String alias = ks.aliases().nextElement();
        return (KeyStore.PrivateKeyEntry)ks.getEntry(alias, new KeyStore.PasswordProtection(this.getP12KeyStorePassword()));
    }

    public char[] getP12KeyStorePassword() {
        return "00".toCharArray();
    }

    public KeyStore.PasswordProtection getP12KeyStoreProtection() {
        return new KeyStore.PasswordProtection(this.getP12KeyStorePassword());
    }

    public String toString() {
        return MessageFormat.format("SmartcardKey with algorithm={0}", this.cryptoSystem);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SmartcardCertificateP12)) {
            return false;
        }
        SmartcardCertificateP12 other = (SmartcardCertificateP12)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Supplier<InputStream> this$certificateStreamSupplier = this.getCertificateStreamSupplier();
        Supplier<InputStream> other$certificateStreamSupplier = other.getCertificateStreamSupplier();
        if (this$certificateStreamSupplier == null ? other$certificateStreamSupplier != null : !this$certificateStreamSupplier.equals(other$certificateStreamSupplier)) {
            return false;
        }
        X509CertificateWrapper this$certWrapper = this.getCertWrapper();
        X509CertificateWrapper other$certWrapper = other.getCertWrapper();
        if (this$certWrapper == null ? other$certWrapper != null : !this$certWrapper.equals(other$certWrapper)) {
            return false;
        }
        PrivateKey this$privateKey = this.getPrivateKey();
        PrivateKey other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        CryptoSystem this$cryptoSystem = this.getCryptoSystem();
        CryptoSystem other$cryptoSystem = other.getCryptoSystem();
        return !(this$cryptoSystem == null ? other$cryptoSystem != null : !this$cryptoSystem.equals(other$cryptoSystem));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SmartcardCertificateP12;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<InputStream> $certificateStreamSupplier = this.getCertificateStreamSupplier();
        result = result * 59 + ($certificateStreamSupplier == null ? 43 : $certificateStreamSupplier.hashCode());
        X509CertificateWrapper $certWrapper = this.getCertWrapper();
        result = result * 59 + ($certWrapper == null ? 43 : $certWrapper.hashCode());
        PrivateKey $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        CryptoSystem $cryptoSystem = this.getCryptoSystem();
        result = result * 59 + ($cryptoSystem == null ? 43 : $cryptoSystem.hashCode());
        return result;
    }

    @Generated
    public Supplier<InputStream> getCertificateStreamSupplier() {
        return this.certificateStreamSupplier;
    }

    @Generated
    public X509CertificateWrapper getCertWrapper() {
        return this.certWrapper;
    }

    @Generated
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public CryptoSystem getCryptoSystem() {
        return this.cryptoSystem;
    }
}

