/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.smartcards.exceptions.InvalidFileExtensionException;
import lombok.Generated;

public enum KeystoreType {
    P12("PKCS12", ".p12"),
    JKS("JKS", ".jks");

    private final String name;
    private final String fileExtension;

    private KeystoreType(String name, String extension) {
        this.name = name;
        this.fileExtension = extension;
    }

    public static KeystoreType fromFileExtension(String fileName) {
        String[] tokens = fileName.split("\\.");
        String ext = tokens.length >= 2 ? tokens[1] : tokens[0];
        return switch (ext.toLowerCase()) {
            case "p12" -> P12;
            case "jks" -> JKS;
            default -> throw new InvalidFileExtensionException(fileName);
        };
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getFileExtension() {
        return this.fileExtension;
    }
}

