/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.crypto.certificate.Oid;
import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.SmartcardCertificate;
import de.gematik.bbriccs.smartcards.SmartcardExtension;
import de.gematik.bbriccs.smartcards.SmartcardOwnerData;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.cfg.SmartcardConfigDto;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class DummyEgk
implements Egk {
    private final SmartcardConfigDto config;
    private final SmartcardOwnerData ownerData;

    public static DummyEgk fromConfig(SmartcardConfigDto config) {
        SmartcardOwnerData ownerData = SmartcardOwnerData.builder().commonName(config.getOwnerName()).build();
        return new DummyEgk(config, ownerData);
    }

    public SmartcardCertificate getAutCertificate() {
        return this.getAutCertificate(CryptoSystem.DEFAULT_CRYPTO_SYSTEM).orElse(null);
    }

    public Optional<SmartcardCertificate> getAutCertificate(CryptoSystem cryptoSystem) {
        return Optional.empty();
    }

    public PrivateKey getAuthPrivateKey() {
        return null;
    }

    public PublicKey getAuthPublicKey() {
        return null;
    }

    public String getPrivateKeyBase64() {
        return "";
    }

    public List<Oid> getAutOids() {
        return List.of(Oid.OID_EGK_AUT, Oid.OID_EGK_AUT_ALT);
    }

    public String getIccsn() {
        return this.config.getIccsn();
    }

    public SmartcardType getType() {
        return SmartcardType.EGK;
    }

    public SmartcardOwnerData getOwnerData() {
        return this.ownerData;
    }

    public Map<String, Object> getExtension() {
        return this.config.getSmartcardExtension();
    }

    public <E extends SmartcardExtension> E getExtensionAs(Class<E> extensionType) {
        return (E)((SmartcardExtension)new ObjectMapper().convertValue(this.getExtension(), extensionType));
    }

    public String getKvnr() {
        return this.config.getIdentifier();
    }

    @Generated
    private DummyEgk(SmartcardConfigDto config, SmartcardOwnerData ownerData) {
        this.config = config;
        this.ownerData = ownerData;
    }
}

