/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.crypto.certificate.Oid;
import de.gematik.bbriccs.smartcards.EgkP12;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmartcardP12;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.cfg.SmartcardConfigDto;
import de.gematik.bbriccs.smartcards.exceptions.InvalidSmartcardTypeException;
import de.gematik.bbriccs.smartcards.exceptions.SmartCardKeyNotFoundException;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class SmartcardTest {
    private static SmartcardArchive archive;

    SmartcardTest() {
    }

    @BeforeAll
    static void setupArchive() {
        File archiveFile = ResourceLoader.getFileFromResource((String)"smartcards");
        archive = SmartcardArchive.from((File)archiveFile);
    }

    @ParameterizedTest
    @MethodSource
    void shouldHaveOwnerData(SmartcardP12 smartcard) {
        Assertions.assertDoesNotThrow(() -> smartcard.getOwnerData().getOwnerName());
        Assertions.assertDoesNotThrow(() -> ((SmartcardP12)smartcard).toString());
    }

    static Stream<Arguments> shouldHaveOwnerData() {
        return Stream.of(Arguments.of((Object[])new Object[]{archive.getEgk(0)}), Arguments.of((Object[])new Object[]{archive.getHba(0)}), Arguments.of((Object[])new Object[]{archive.getSmcB(0)}));
    }

    @ParameterizedTest
    @MethodSource(value={"shouldHaveOwnerData"})
    void shouldProvideAuthCryptoKeys(SmartcardP12 smartcard) {
        Assertions.assertDoesNotThrow(() -> ((SmartcardP12)smartcard).getAuthPrivateKey());
        Assertions.assertDoesNotThrow(() -> ((SmartcardP12)smartcard).getAuthPublicKey());
    }

    @Test
    void shouldThrowOnMissingAuthCertificate() {
        List certificates = List.of();
        SmartcardConfigDto config = new SmartcardConfigDto();
        config.setType(SmartcardType.EGK);
        Assertions.assertThrows(SmartCardKeyNotFoundException.class, () -> new EgkP12(config, certificates));
    }

    @Test
    void shouldDetectMissconfiguredType() {
        SmartcardConfigDto config = new SmartcardConfigDto();
        config.setType(SmartcardType.EGK);
        Assertions.assertThrows(InvalidSmartcardTypeException.class, () -> new TestSmartcard(SmartcardType.HBA, config));
    }

    private static class TestSmartcard
    extends SmartcardP12 {
        public TestSmartcard(SmartcardType type, SmartcardConfigDto config) {
            super(type, config, List.of());
        }

        public List<Oid> getAutOids() {
            return List.of();
        }
    }
}

