/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.EgkP12;
import de.gematik.bbriccs.smartcards.LdapReader;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmartcardCertificate;
import de.gematik.bbriccs.smartcards.SmartcardOwnerData;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.cfg.SmartcardConfigDto;
import de.gematik.bbriccs.smartcards.exceptions.InvalidCertificateException;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class EgkP12Test {
    private static SmartcardArchive archive;

    EgkP12Test() {
    }

    @BeforeAll
    static void setupArchive() {
        File archiveFile = ResourceLoader.getFileFromResource((String)"smartcards");
        archive = SmartcardArchive.from((File)archiveFile);
    }

    @Test
    void shouldGetPrivateKeysAsBase64() {
        archive.getICCSNsFor(SmartcardType.EGK).forEach(egk -> Assertions.assertDoesNotThrow(() -> archive.getEgkByICCSN(egk).getPrivateKeyBase64()));
    }

    @Test
    void shouldGetDefaultKey() {
        List.of(CryptoSystem.ECC_256, CryptoSystem.RSA_2048).forEach(crpyto -> archive.getICCSNsFor(SmartcardType.EGK).stream().map(iccsn -> archive.getEgkByICCSN(iccsn)).forEach(egk -> Assertions.assertTrue((boolean)egk.getAutCertificate(crpyto).isPresent())));
    }

    @Test
    void shouldThrowOnMissingKvnrInCertificates() {
        Egk egk = archive.getEgk(0);
        try (MockedStatic mockLdap = Mockito.mockStatic(LdapReader.class);){
            mockLdap.when(() -> LdapReader.getOwnerData((X500Principal)egk.getAutCertificate().getX509Certificate().getSubjectX500Principal())).thenReturn((Object)SmartcardOwnerData.builder().commonName("Max Mustermann").organizationUnit("123").build());
            List<SmartcardCertificate> certificates = List.of(egk.getAutCertificate());
            SmartcardConfigDto config = new SmartcardConfigDto();
            config.setType(SmartcardType.EGK);
            Assertions.assertThrows(InvalidCertificateException.class, () -> new EgkP12(config, certificates));
        }
    }
}

