/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.crypto.certificate.Oid;
import de.gematik.bbriccs.smartcards.DummyEgk;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmartcardExtension;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.cfg.SmartcardConfigDto;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DummyEgkTest {
    DummyEgkTest() {
    }

    @Test
    void shouldGenerateDummyEgkFromConfig() {
        SmartcardArchive sca = SmartcardArchive.fromResources();
        SmartcardConfigDto config = (SmartcardConfigDto)sca.getConfigsFor(SmartcardType.EGK).get(0);
        DummyEgk egk = DummyEgk.fromConfig((SmartcardConfigDto)config);
        Assertions.assertNotNull((Object)egk);
        Assertions.assertEquals((Object)config.getIccsn(), (Object)egk.getIccsn());
        Assertions.assertEquals((Object)config.getIdentifier(), (Object)egk.getKvnr());
        Assertions.assertEquals((Object)SmartcardType.EGK, (Object)egk.getType());
        Assertions.assertEquals(List.of(Oid.OID_EGK_AUT, Oid.OID_EGK_AUT_ALT), (Object)egk.getAutOids());
        Assertions.assertNotNull((Object)egk.getOwnerData());
        Assertions.assertTrue((boolean)egk.getOwnerData().getCommonName().contains(config.getOwnerName()));
        Assertions.assertNull((Object)egk.getAutCertificate());
        Assertions.assertNull((Object)egk.getAuthPrivateKey());
        Assertions.assertNull((Object)egk.getAuthPublicKey());
        Assertions.assertTrue((boolean)egk.getPrivateKeyBase64().isEmpty());
        DummyExtension extension = (DummyExtension)Assertions.assertDoesNotThrow(() -> (DummyExtension)egk.getExtensionAs(DummyExtension.class));
        Assertions.assertNotNull((Object)extension);
    }

    private static class DummyExtension
    implements SmartcardExtension {
        private DummyExtension() {
        }
    }
}

