/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.crypto.certificate.Oid;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmcB;
import de.gematik.bbriccs.smartcards.exceptions.SmartCardKeyNotFoundException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SmcBP12Test {
    private static final SmartcardArchive archive = SmartcardArchive.fromResources();

    SmcBP12Test() {
    }

    @Test
    void getOSigCertificate() {
        SmcB smcb = archive.getSmcB(0);
        Assertions.assertNotNull((Object)smcb.getOSigCertificate(CryptoSystem.RSA_2048));
    }

    @Test
    void shouldThrowOnMissingOSigCertificate() {
        SmcB smcb = archive.getSmcbByICCSN("80276001011699901102");
        Assertions.assertThrows(SmartCardKeyNotFoundException.class, () -> smcb.getOSigCertificate(CryptoSystem.RSA_PSS_2048));
    }

    @Test
    void getEncCertificate() {
        SmcB smcb = archive.getSmcB(0);
        Assertions.assertNotNull((Object)smcb.getEncCertificate(CryptoSystem.RSA_2048));
    }

    @Test
    void getAutOids() {
        SmcB smcb = archive.getSmcB(0);
        Assertions.assertEquals(List.of(Oid.OID_SMC_B_AUT), (Object)smcb.getAutOids());
    }
}

