/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.crypto.certificate.Oid;
import de.gematik.bbriccs.smartcards.EgkP12;
import de.gematik.bbriccs.smartcards.HbaP12;
import de.gematik.bbriccs.smartcards.SmartcardP12;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.SmcBP12;
import de.gematik.bbriccs.smartcards.cfg.SmartcardConfigDto;
import de.gematik.bbriccs.smartcards.exceptions.InvalidSmartcardTypeException;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class SmartcardTypeTest {
    SmartcardTypeTest() {
    }

    @Test
    void shouldGetSmartcardTypeFromString() {
        Map<String, SmartcardType> inputs = Map.of("egk", SmartcardType.EGK, "hba", SmartcardType.HBA, "smcb", SmartcardType.SMC_B, "smc-b", SmartcardType.SMC_B, "smckt", SmartcardType.SMC_KT, "EGK", SmartcardType.EGK, "h-b-a", SmartcardType.HBA, "HbA", SmartcardType.HBA);
        inputs.forEach((k, v) -> Assertions.assertEquals((Object)v, (Object)SmartcardType.fromString((String)k)));
    }

    @Test
    void shouldThrowOnSmartcardTypeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> SmartcardType.fromString(null));
    }

    @Test
    void shouldThrowOnInvalidSmartcardType() {
        List<String> inputs = List.of("smc-a", "SMC-D", "egk2");
        inputs.forEach(input -> Assertions.assertThrows(InvalidSmartcardTypeException.class, () -> SmartcardType.fromString((String)"SMC-D")));
    }

    @ParameterizedTest
    @MethodSource
    void shouldMapSmartcardTypeFromImplementationClass(Class<SmartcardP12> clazz, SmartcardType expectedType) {
        SmartcardType type = SmartcardType.fromImplementationType(clazz);
        Assertions.assertEquals((Object)expectedType, (Object)type);
    }

    static Stream<Arguments> shouldMapSmartcardTypeFromImplementationClass() {
        return Stream.of(Arguments.of((Object[])new Object[]{EgkP12.class, SmartcardType.EGK}), Arguments.of((Object[])new Object[]{HbaP12.class, SmartcardType.HBA}), Arguments.of((Object[])new Object[]{SmcBP12.class, SmartcardType.SMC_B}));
    }

    @Test
    void shouldThrowOnUnknownSmartcardImplementation() {
        Assertions.assertThrows(InvalidSmartcardTypeException.class, () -> SmartcardType.fromImplementationType(UnknownSmartcard.class));
    }

    private static class UnknownSmartcard
    extends SmartcardP12 {
        protected UnknownSmartcard() {
            super(SmartcardType.SMC_KT, new SmartcardConfigDto(), List.of());
        }

        public List<Oid> getAutOids() {
            return List.of();
        }
    }
}

