/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.SmartcardFactory;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.cfg.SmartcardConfigDto;
import de.gematik.bbriccs.smartcards.exceptions.SmartcardFactoryException;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Path;
import java.time.Instant;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SmartcardFactoryTest {
    SmartcardFactoryTest() {
    }

    @Test
    void shouldThrowOnNonExistentImagesFile() {
        File images = Path.of("a/b/c", new String[0]).toFile();
        Assertions.assertThrows(SmartcardFactoryException.class, () -> SmartcardFactory.fromFileSystem((File)images));
    }

    @Test
    void shouldThrowOnInvalidImagesFile() {
        Path tmpDir = Path.of(System.getProperty("user.dir"), "target", "tmp", Instant.now().toString());
        Assertions.assertTrue((boolean)tmpDir.toFile().mkdirs());
        File tmpFile = Path.of(tmpDir.toString(), "smartcards.json").toFile();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(tmpFile));){
            writer.write("{'invalid': 'images-file'}");
        }
        Assertions.assertThrows(SmartcardFactoryException.class, () -> SmartcardFactory.fromFileSystem((File)tmpFile));
    }

    @Test
    void shouldLoadEgkByKvnr() {
        File archiveFile = ResourceLoader.getFileFromResource((String)"smartcards");
        SmartcardFactory factory = SmartcardFactory.fromFileSystem((File)archiveFile);
        SmartcardConfigDto egkConfig = factory.getConfigFor(SmartcardType.EGK, 0);
        Egk egk = (Egk)Assertions.assertDoesNotThrow(() -> factory.loadEgkByKvnr(egkConfig.getIdentifier()));
        Assertions.assertNotNull((Object)egk);
    }
}

