/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.crypto.certificate.Oid;
import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmartcardCertificateP12;
import de.gematik.bbriccs.smartcards.exceptions.InvalidCertificateException;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SmartcardCertificateP12Test {
    private static SmartcardArchive archive;
    private SmartcardCertificateP12 smartcardCertificate;

    SmartcardCertificateP12Test() {
    }

    @BeforeAll
    static void setupArchive() {
        File archiveFile = ResourceLoader.getFileFromResource((String)"smartcards");
        archive = SmartcardArchive.from((File)archiveFile);
    }

    @BeforeEach
    void setUp() {
        Egk egk = archive.getEgk(0);
        Path certPath = Paths.get(Objects.requireNonNull(this.getClass().getResource("/")).getPath(), "tmp");
        Files.createDirectories(certPath.toAbsolutePath(), new FileAttribute[0]);
        Supplier certIS = egk.getAutCertificate().getCertificateStream();
        Path certFile = Paths.get(certPath.toString(), egk.getKvnr() + ".p12");
        Files.copy((InputStream)certIS.get(), certFile, StandardCopyOption.REPLACE_EXISTING);
        this.smartcardCertificate = new SmartcardCertificateP12(certFile.toString(), () -> {
            try {
                return Files.newInputStream(certFile, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    void shouldGetX509Certificate() {
        Assertions.assertNotNull((Object)this.smartcardCertificate.getX509Certificate());
        Assertions.assertEquals((Object)"1.2.840.10045.4.3.2", (Object)this.smartcardCertificate.getX509Certificate().getSigAlgOID());
    }

    @Test
    void shouldGetX509CertificateHolder() {
        Assertions.assertNotNull((Object)this.smartcardCertificate.getX509CertificateHolder());
        Assertions.assertEquals((Object)new BigInteger("1068563247561708"), (Object)this.smartcardCertificate.getX509CertificateHolder().getSerialNumber());
    }

    @Test
    void getOid() {
        Assertions.assertNotNull((Object)this.smartcardCertificate.getX509Certificate());
        Assertions.assertEquals((Object)Oid.OID_EGK_AUT, (Object)this.smartcardCertificate.getOid());
    }

    @Test
    void getInputStreamSupplier() {
        Assertions.assertDoesNotThrow(() -> this.smartcardCertificate.getCertificateStream());
        Assertions.assertNotNull(this.smartcardCertificate.getCertificateStream().get());
    }

    @Test
    void shouldThrowOnNonExistentSmartcardCertificate() {
        Path tmpDir = Path.of(System.getProperty("user.dir"), "target", "tmp", Instant.now().toString());
        Assertions.assertTrue((boolean)tmpDir.toFile().mkdirs());
        File tmpFile = Path.of(tmpDir.toString(), "file_0.p12").toFile();
        String tmpFilePath = tmpFile.getPath();
        InvalidCertificateException exception = (InvalidCertificateException)Assertions.assertThrows(InvalidCertificateException.class, () -> new SmartcardCertificateP12(tmpFilePath, null));
        Assertions.assertTrue((boolean)exception.getMessage().contains(tmpFile.getName()));
    }

    @Test
    void shouldThrowOnInvalidSmartcardCertificate() {
        Path tmpDir = Path.of(System.getProperty("user.dir"), "target", "tmp", Instant.now().toString());
        Assertions.assertTrue((boolean)tmpDir.toFile().mkdirs());
        File tmpFile = Path.of(tmpDir.toString(), "file_0.p12").toFile();
        String tmpFilePath = tmpFile.getPath();
        try (FileOutputStream writer = new FileOutputStream(tmpFile);){
            writer.write("Hello World".getBytes());
        }
        InvalidCertificateException exception = (InvalidCertificateException)Assertions.assertThrows(InvalidCertificateException.class, () -> new SmartcardCertificateP12(tmpFilePath, null));
        Assertions.assertTrue((boolean)exception.getMessage().contains(tmpFile.getName()));
    }

    @Test
    void shouldGetPrivateKey() {
        Assertions.assertNotNull((Object)this.smartcardCertificate.getPrivateKey());
    }

    @Test
    void shouldGetAlgorithm() {
        Assertions.assertEquals((Object)CryptoSystem.ECC_256, (Object)this.smartcardCertificate.getCryptoSystem());
    }

    @Test
    void shouldGetDefaultStoreProtection() {
        KeyStore.PasswordProtection p = (KeyStore.PasswordProtection)Assertions.assertDoesNotThrow(() -> this.smartcardCertificate.getP12KeyStoreProtection());
        Assertions.assertNotNull((Object)p);
        Assertions.assertEquals((Object)"00", (Object)new String(p.getPassword()));
    }
}

