/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.crypto.certificate.Oid;
import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.EgkP12;
import de.gematik.bbriccs.smartcards.Hba;
import de.gematik.bbriccs.smartcards.HbaP12;
import de.gematik.bbriccs.smartcards.InstituteSmartcard;
import de.gematik.bbriccs.smartcards.InstituteSmartcardP12;
import de.gematik.bbriccs.smartcards.Smartcard;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmartcardExtension;
import de.gematik.bbriccs.smartcards.SmartcardP12;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.SmcB;
import de.gematik.bbriccs.smartcards.SmcBP12;
import de.gematik.bbriccs.smartcards.cfg.SmartcardConfigDto;
import de.gematik.bbriccs.smartcards.exceptions.CardNotFoundException;
import de.gematik.bbriccs.smartcards.exceptions.InvalidSmartcardTypeException;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;

class SmartcardArchiveTest {
    private static SmartcardArchive providerArchive;

    SmartcardArchiveTest() {
    }

    @BeforeAll
    static void setup() {
        providerArchive = SmartcardArchive.fromResources();
    }

    static Stream<Arguments> shouldGetSmartcardByType() {
        return Stream.of(Arguments.of((Object[])new Object[]{SmartcardType.EGK, providerArchive.getICCSNsFor(SmartcardType.EGK).get(0)}), Arguments.of((Object[])new Object[]{SmartcardType.HBA, providerArchive.getICCSNsFor(SmartcardType.HBA).get(0)}), Arguments.of((Object[])new Object[]{SmartcardType.SMC_B, providerArchive.getICCSNsFor(SmartcardType.SMC_B).get(0)}));
    }

    static Stream<Arguments> shouldGetSmartcardByClassType() {
        return Stream.of(Arguments.of((Object[])new Object[]{Egk.class, providerArchive.getICCSNsFor(SmartcardType.EGK).get(0)}), Arguments.of((Object[])new Object[]{EgkP12.class, providerArchive.getICCSNsFor(SmartcardType.EGK).get(0)}), Arguments.of((Object[])new Object[]{Hba.class, providerArchive.getICCSNsFor(SmartcardType.HBA).get(0)}), Arguments.of((Object[])new Object[]{HbaP12.class, providerArchive.getICCSNsFor(SmartcardType.HBA).get(0)}), Arguments.of((Object[])new Object[]{SmcB.class, providerArchive.getICCSNsFor(SmartcardType.SMC_B).get(0)}), Arguments.of((Object[])new Object[]{SmcBP12.class, providerArchive.getICCSNsFor(SmartcardType.SMC_B).get(0)}), Arguments.of((Object[])new Object[]{InstituteSmartcard.class, providerArchive.getICCSNsFor(SmartcardType.SMC_B).get(0)}), Arguments.of((Object[])new Object[]{InstituteSmartcardP12.class, providerArchive.getICCSNsFor(SmartcardType.SMC_B).get(0)}), Arguments.of((Object[])new Object[]{Smartcard.class, providerArchive.getICCSNsFor(SmartcardType.SMC_B).get(0)}), Arguments.of((Object[])new Object[]{SmartcardP12.class, providerArchive.getICCSNsFor(SmartcardType.SMC_B).get(0)}));
    }

    public static void resetArchiveCache() {
        Field instance = SmartcardArchive.class.getDeclaredField("ARCHIVE_CACHE");
        instance.setAccessible(true);
        HashMap cache = (HashMap)instance.get(null);
        cache.clear();
    }

    @ParameterizedTest
    @MethodSource
    void shouldGetSmartcardByClassType(Class<? extends Smartcard> type, String iccsn) {
        SmartcardArchive archive = SmartcardArchive.fromResources();
        Smartcard smartcard = (Smartcard)Assertions.assertDoesNotThrow(() -> archive.getByICCSN(type, iccsn));
        Assertions.assertEquals((Object)iccsn, (Object)smartcard.getIccsn());
    }

    @ParameterizedTest
    @MethodSource(value={"shouldGetSmartcardByClassType"})
    void shouldGetSmartcardWithoutClassType(Class<? extends Smartcard> type, String iccsn) {
        SmartcardArchive archive = SmartcardArchive.fromResources();
        Optional smartcard = (Optional)Assertions.assertDoesNotThrow(() -> archive.getByICCSN(iccsn));
        Assertions.assertTrue((boolean)smartcard.isPresent());
        Assertions.assertEquals((Object)iccsn, (Object)((Smartcard)smartcard.get()).getIccsn());
    }

    @ParameterizedTest
    @MethodSource
    void shouldGetSmartcardByType(SmartcardType type, String iccsn) {
        SmartcardArchive archive = SmartcardArchive.fromResources();
        Smartcard smartcard = (Smartcard)Assertions.assertDoesNotThrow(() -> archive.getSmartcardByICCSN(type, iccsn));
        Assertions.assertEquals((Object)iccsn, (Object)smartcard.getIccsn());
    }

    @Test
    void shouldThrowOnUnsupportedSmartcardType() {
        SmartcardArchive archive = SmartcardArchive.fromResources();
        String iccsn = (String)providerArchive.getICCSNsFor(SmartcardType.SMC_B).get(0);
        Assertions.assertThrows(InvalidSmartcardTypeException.class, () -> archive.getSmartcardByICCSN(SmartcardType.SMC_KT, iccsn));
    }

    @Test
    void shouldThrowOnUnsupportedSmartcardTypeClass() {
        SmartcardArchive archive = SmartcardArchive.fromResources();
        String iccsn = (String)providerArchive.getICCSNsFor(SmartcardType.SMC_B).get(0);
        Assertions.assertThrows(InvalidSmartcardTypeException.class, () -> archive.getByICCSN(TestSmartcard.class, iccsn));
    }

    @Test
    void shouldThrowOnUnknownSmartcard() {
        File archiveFile = ResourceLoader.getFileFromResource((String)"smartcards");
        SmartcardArchive archive = SmartcardArchive.from((File)archiveFile);
        Assertions.assertDoesNotThrow(() -> archive.getICCSNsFor(SmartcardType.EGK));
        Assertions.assertDoesNotThrow(() -> archive.getICCSNsFor(SmartcardType.HBA));
        Assertions.assertDoesNotThrow(() -> archive.getICCSNsFor(SmartcardType.SMC_B));
        Assertions.assertThrows(CardNotFoundException.class, () -> archive.getEgkByICCSN("123"));
    }

    @Test
    void shouldThrowOnUnknownKvnr() {
        File archiveFile = ResourceLoader.getFileFromResource((String)"smartcards");
        SmartcardArchive archive = SmartcardArchive.from((File)archiveFile);
        Assertions.assertThrows(CardNotFoundException.class, () -> archive.getEgkByKvnr("123"));
    }

    @Test
    void shouldBeAbleToHaveCommentsOnCardConfig() {
        SmartcardArchive archive = SmartcardArchive.fromResources();
        SmartcardConfigDto egk = (SmartcardConfigDto)archive.getConfigsFor(SmartcardType.EGK).get(0);
        Assertions.assertNotNull((Object)egk.getNote());
        Assertions.assertFalse((boolean)egk.getNote().isEmpty());
    }

    @Test
    void shouldCacheSmartcards() {
        File archiveFile = ResourceLoader.getFileFromResource((String)"smartcards");
        SmartcardArchive archive = SmartcardArchive.from((String)archiveFile.getAbsolutePath());
        Egk first = archive.getEgk(0);
        Egk second = archive.getEgkByICCSN(first.getIccsn());
        Assertions.assertEquals((Object)first, (Object)second);
    }

    @Test
    void shouldCacheSmartcardsByKvnr01() {
        File archiveFile = ResourceLoader.getFileFromResource((String)"smartcards/smartcards.json");
        SmartcardArchive archive = SmartcardArchive.from((File)archiveFile);
        Egk first = archive.getEgk(0);
        Egk second = archive.getEgkByKvnr(first.getKvnr());
        Assertions.assertEquals((Object)first, (Object)second);
    }

    @Test
    void shouldCacheSmartcardsByKvnr02() {
        File archiveFile = ResourceLoader.getFileFromResource((String)"smartcards/smartcards.json");
        SmartcardArchive archive = SmartcardArchive.from((File)archiveFile);
        Egk first = archive.getEgkByKvnr("X110406067");
        Egk second = archive.getEgkByKvnr(first.getKvnr());
        Assertions.assertEquals((Object)first, (Object)second);
    }

    @Test
    void shouldCacheSmartcardsByKvnr03() {
        SmartcardArchiveTest.resetArchiveCache();
        File archiveFile = ResourceLoader.getFileFromResource((String)"smartcards/smartcards.json");
        SmartcardArchive archive = SmartcardArchive.from((File)archiveFile);
        Egk first = archive.getEgkByKvnr("X110406067");
        Egk second = archive.getEgkByKvnr(first.getKvnr());
        Assertions.assertEquals((Object)first, (Object)second);
    }

    @Test
    void shouldGetConfigsFromCache() {
        SmartcardArchive archive = SmartcardArchive.fromResources();
        Assertions.assertFalse((boolean)archive.getConfigs().isEmpty());
    }

    @ParameterizedTest
    @MethodSource
    void shouldReadAllBundledEgks(ComplexLoadParameter param) {
        SmartcardArchive archive = SmartcardArchive.fromResources();
        Function<SmartcardArchive, List<? extends Smartcard>> fetcher = param.fetcher;
        List<String> iccsns = param.iccsns;
        List<? extends Smartcard> smartcards = fetcher.apply(archive);
        Assertions.assertEquals((int)smartcards.size(), (int)iccsns.size());
        smartcards.forEach(s -> Assertions.assertTrue((boolean)iccsns.contains(s.getIccsn())));
    }

    static Stream<Arguments> shouldReadAllBundledEgks() {
        return Stream.of(new ComplexLoadParameter(SmartcardArchive::getEgkCards, List.of("80276883110000113311", "80276883110000108142")), new ComplexLoadParameter(SmartcardArchive::getHbaCards, List.of("80276001011699901501")), new ComplexLoadParameter(SmartcardArchive::getSmcbCards, List.of("80276001011699901102", "80276001011699900861"))).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @EnumSource(value=SmartcardType.class, mode=EnumSource.Mode.EXCLUDE, names={"SMC_KT"})
    void shouldGetTypedConfigsFromCache(SmartcardType type) {
        SmartcardArchive archive = SmartcardArchive.fromResources();
        Assertions.assertFalse((boolean)archive.getConfigsFor(type).isEmpty());
    }

    @Test
    void shouldReadExtensionAsMapFromArchive() {
        SmartcardArchive archive = SmartcardArchive.fromResources();
        SmartcardConfigDto egkConfig = archive.getConfigsFor(SmartcardType.EGK).stream().filter(c -> c.getIccsn().equals("80276883110000108142")).findFirst().orElseThrow();
        Map ext = egkConfig.getSmartcardExtension();
        Assertions.assertEquals((Object)"Hello", ext.get("first"));
        Assertions.assertEquals((Object)"World", ext.get("second"));
        Assertions.assertEquals((Object)73, ext.get("num"));
    }

    @Test
    void shouldReadExtensionAsObject() {
        SmartcardArchive archive = SmartcardArchive.fromResources();
        Smartcard egkConfig = (Smartcard)archive.getByICCSN("80276883110000108142").orElseThrow();
        HelloWorldSmartcardExtension ext = (HelloWorldSmartcardExtension)egkConfig.getExtensionAs(HelloWorldSmartcardExtension.class);
        Assertions.assertEquals((Object)"Hello", (Object)ext.first);
        Assertions.assertEquals((Object)"World", (Object)ext.second);
        Assertions.assertEquals((int)73, (int)ext.num);
    }

    private record ComplexLoadParameter(Function<SmartcardArchive, List<? extends Smartcard>> fetcher, List<String> iccsns) {
    }

    private static class HelloWorldSmartcardExtension
    implements SmartcardExtension {
        private String first;
        private String second;
        private int num;

        @Generated
        public HelloWorldSmartcardExtension() {
        }

        @Generated
        public String getFirst() {
            return this.first;
        }

        @Generated
        public String getSecond() {
            return this.second;
        }

        @Generated
        public int getNum() {
            return this.num;
        }

        @Generated
        public void setFirst(String first) {
            this.first = first;
        }

        @Generated
        public void setSecond(String second) {
            this.second = second;
        }

        @Generated
        public void setNum(int num) {
            this.num = num;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HelloWorldSmartcardExtension)) {
                return false;
            }
            HelloWorldSmartcardExtension other = (HelloWorldSmartcardExtension)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNum() != other.getNum()) {
                return false;
            }
            String this$first = this.getFirst();
            String other$first = other.getFirst();
            if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
                return false;
            }
            String this$second = this.getSecond();
            String other$second = other.getSecond();
            return !(this$second == null ? other$second != null : !this$second.equals(other$second));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HelloWorldSmartcardExtension;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNum();
            String $first = this.getFirst();
            result = result * 59 + ($first == null ? 43 : $first.hashCode());
            String $second = this.getSecond();
            result = result * 59 + ($second == null ? 43 : $second.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SmartcardArchiveTest.HelloWorldSmartcardExtension(first=" + this.getFirst() + ", second=" + this.getSecond() + ", num=" + this.getNum() + ")";
        }
    }

    private static class TestSmartcard
    extends SmartcardP12 {
        protected TestSmartcard(SmartcardConfigDto config) {
            super(SmartcardType.SMC_KT, config, List.of());
        }

        public static TestSmartcard forIccsn(String iccsn) {
            SmartcardConfigDto config = new SmartcardConfigDto();
            config.setIccsn(iccsn);
            return new TestSmartcard(config);
        }

        public List<Oid> getAutOids() {
            return List.of();
        }
    }
}

