/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.smartcards.LdapReader;
import de.gematik.bbriccs.smartcards.SmartcardOwnerData;
import de.gematik.bbriccs.utils.PrivateConstructorsUtil;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class LdapReaderTest {
    LdapReaderTest() {
    }

    private static Stream<Arguments> getReferenceOwnerData() {
        return Stream.of(Arguments.of((Object[])new Object[]{"GIVENNAME=Bernd + SURNAME=Claudius + SERIALNUMBER=16.80276001011699910102 + CN=Arzt Bernd Claudius TEST-ONLY, C=DE", "Bernd", "Claudius", "Arzt Bernd Claudius TEST-ONLY"}), Arguments.of((Object[])new Object[]{"SURNAME=Gunther + GIVENNAME=G\u00fcnd\u00fcla + SERIALNUMBER=11.80276001081699900578 + CN=Dr. med. G\u00fcnd\u00fcla Gunther ARZT TEST-ONLY, C=DE + T = Dr. med. + STREET = Friedrichstrasse 136 + POSTALCODE = 10117 + OU = someOrganizationUnit + L = locality", "G\u00fcnd\u00fcla", "Gunther", "Dr. med. G\u00fcnd\u00fcla Gunther ARZT TEST-ONLY", "Dr. med.", "Friedrichstrasse 136", "10117", "someOrganizationUnit", "locality"}), Arguments.of((Object[])new Object[]{"GIVENNAME=Amanda + SURNAME=Albrecht + SERIALNUMBER=11.80276001081699900579 + CN=Dr. Amanda Albrecht APO TEST-ONLY, C=DE", "Amanda", "Albrecht", "Dr. Amanda Albrecht APO TEST-ONLY"}), Arguments.of((Object[])new Object[]{"CN=Arztpraxis Bernd Claudius TEST-ONLY, GIVENNAME=Bernd, SURNAME=Claudius, O=202110001 NOT-VALID, C=DE", "Bernd", "Claudius", "Arztpraxis Bernd Claudius TEST-ONLY"}));
    }

    @ParameterizedTest
    @MethodSource
    void getReferenceOwnerData(String subject, String givenName, String surname, String commonName) {
        SmartcardOwnerData bernd = LdapReader.getOwnerData((String)subject);
        Assertions.assertEquals((Object)givenName, (Object)bernd.getGivenName());
        Assertions.assertEquals((Object)surname, (Object)bernd.getSurname());
        Assertions.assertEquals((Object)commonName, (Object)bernd.getCommonName());
    }

    @Test
    void constructorShouldNotBeCallable() {
        Assertions.assertTrue((boolean)PrivateConstructorsUtil.isUtilityConstructor(LdapReader.class));
    }
}

