/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.smartcards.KeystoreType;
import de.gematik.bbriccs.smartcards.exceptions.InvalidFileExtensionException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class KeystoreTypeTest {
    KeystoreTypeTest() {
    }

    @Test
    void shouldGetCorrectKeystoreType() {
        List<KeystoreType> types = List.of(KeystoreType.JKS, KeystoreType.P12);
        types.forEach(t -> Assertions.assertEquals((Object)t, (Object)KeystoreType.fromFileExtension((String)t.getFileExtension())));
    }

    @Test
    void shouldThrowOnKeystoreTypeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> KeystoreType.fromFileExtension(null));
    }

    @Test
    void shouldGetCorrectKeystoreTypeFromFilename() {
        KeystoreType typeP12 = KeystoreType.fromFileExtension((String)"keystore.p12");
        Assertions.assertEquals((Object)KeystoreType.P12, (Object)typeP12);
        KeystoreType typeJks = KeystoreType.fromFileExtension((String)"keystore.jks");
        Assertions.assertEquals((Object)KeystoreType.JKS, (Object)typeJks);
    }

    @Test
    void shouldGetCorrectKeystoreTypeFromPlainExtension() {
        KeystoreType typeP12 = KeystoreType.fromFileExtension((String)"p12");
        Assertions.assertEquals((Object)KeystoreType.P12, (Object)typeP12);
        KeystoreType typeJks = KeystoreType.fromFileExtension((String)"JKS");
        Assertions.assertEquals((Object)KeystoreType.JKS, (Object)typeJks);
    }

    @Test
    void shouldThrowOnInvalidExtension() {
        List<String> invalid = List.of("test.txt", "keystore.p120", "exe", "");
        invalid.forEach(ext -> Assertions.assertThrows(InvalidFileExtensionException.class, () -> KeystoreType.fromFileExtension((String)ext)));
    }
}

