/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.Hba;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.exceptions.SmartCardKeyNotFoundException;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class HbaP12Test {
    private static SmartcardArchive archive;

    HbaP12Test() {
    }

    @BeforeAll
    static void setupArchive() {
        File archiveFile = ResourceLoader.getFileFromResource((String)"smartcards");
        archive = SmartcardArchive.from((File)archiveFile);
    }

    @Test
    void shouldReadQesFromSupplier() {
        Hba first = archive.getICCSNsFor(SmartcardType.HBA).stream().map(iccsn -> archive.getHbaByICCSN(iccsn)).findFirst().orElseThrow();
        Supplier supplier = first.getQesCertificate(CryptoSystem.RSA_2048).getCertificateStream();
        try (InputStream stream = (InputStream)supplier.get();){
            Assertions.assertNotNull((Object)stream);
        }
        catch (IOException e) {
            Assertions.fail();
        }
    }

    @Test
    void shouldEqualOnSame() {
        Hba first = archive.getHba(0);
        Hba second = archive.getHba(0);
        Assertions.assertEquals((Object)first, (Object)second);
        Assertions.assertEquals((int)first.hashCode(), (int)second.hashCode());
    }

    @Test
    void shouldNotEqualOnNull() {
        String iccsn = "80276001011699901501";
        Hba first = archive.getHbaByICCSN("80276001011699901501");
        Assertions.assertNotEquals(null, (Object)first);
    }

    @Test
    void shouldNotEqualOnDifferentCards() {
        Hba first = archive.getHba(0);
        Egk second = archive.getEgk(0);
        Assertions.assertNotEquals((Object)first, (Object)second);
    }

    @Test
    void getTelematikId() {
        Hba hba = archive.getHba(0);
        Assertions.assertNotNull((Object)hba.getTelematikId());
    }

    @Test
    void getEncCertificate() {
        Hba hba = archive.getHba(0);
        Assertions.assertDoesNotThrow(() -> hba.getEncCertificate(CryptoSystem.RSA_2048));
        Assertions.assertNotNull((Object)hba.getEncCertificate(CryptoSystem.RSA_2048));
    }

    @Test
    void shouldThrowSmartCardKeyNotFoundException() {
        Hba hba = archive.getHba(0);
        Assertions.assertThrows(SmartCardKeyNotFoundException.class, () -> hba.getEncCertificate(CryptoSystem.RSA_PSS_2048));
    }
}

