/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.EgkP12;
import de.gematik.bbriccs.smartcards.SmartcardCertificateP12;
import de.gematik.bbriccs.smartcards.SmartcardP12;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.cfg.SmartcardConfigDto;
import de.gematik.bbriccs.smartcards.exceptions.CardNotFoundException;
import de.gematik.bbriccs.smartcards.exceptions.SmartcardFactoryException;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmartcardFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmartcardFactory.class);
    private static final String DEFAULT_INDEX_DIR = "smartcards";
    private static final String DEFAULT_INDEX_FILE = "smartcards.json";
    private final Function<String, InputStream> fileLoader;
    private final List<SmartcardConfigDto> configs;

    private SmartcardFactory(List<SmartcardConfigDto> configs, Function<String, InputStream> fileLoader) {
        this.fileLoader = fileLoader;
        this.configs = configs;
    }

    public List<SmartcardConfigDto> getConfigsFor(SmartcardType type) {
        return this.configs.stream().filter(config -> config.getType().equals((Object)type)).toList();
    }

    public SmartcardConfigDto getConfigFor(SmartcardType type, int idx) {
        return this.getConfigsFor(type).get(idx);
    }

    public <S extends SmartcardP12> S loadSmartcardByIccsn(Class<S> smartcardType, String iccsn) {
        SmartcardConfigDto config = this.loadSmartcardConfig(SmartcardType.fromImplementationType(smartcardType), iccsn);
        Constructor<S> constructor = smartcardType.getConstructor(SmartcardConfigDto.class, List.class);
        List<SmartcardCertificateP12> certificates = config.getStores().stream().map(path -> {
            log.trace(MessageFormat.format("Load Smartcard certificate from Store={0}", path));
            return new SmartcardCertificateP12((String)path, () -> this.fileLoader.apply((String)path));
        }).toList();
        return (S)((SmartcardP12)constructor.newInstance(config, certificates));
    }

    public Egk loadEgkByKvnr(String kvnr) {
        return this.configs.stream().filter(it -> it.getType() == SmartcardType.EGK).filter(it -> it.getIdentifier().equals(kvnr)).findFirst().map(it -> this.loadSmartcardByIccsn(EgkP12.class, it.getIccsn())).orElseThrow(() -> new CardNotFoundException(SmartcardType.EGK, kvnr));
    }

    private SmartcardConfigDto loadSmartcardConfig(SmartcardType smartcardType, String iccsn) {
        return this.configs.stream().filter(it -> smartcardType.equals((Object)it.getType())).filter(it -> it.getIccsn().equals(iccsn)).findFirst().orElseThrow(() -> new CardNotFoundException(smartcardType, iccsn));
    }

    private static List<SmartcardConfigDto> loadConfigs(Path basePath, Supplier<InputStream> indexFile) {
        List list;
        block8: {
            InputStream is = indexFile.get();
            try {
                list = (List)new ObjectMapper().readValue(is, (TypeReference)new TypeReference<List<SmartcardConfigDto>>(){});
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SmartcardFactoryException(MessageFormat.format("Unable to load Smartcard-Index from {0}", basePath), (Throwable)e);
                }
            }
            is.close();
        }
        return list;
    }

    public static SmartcardFactory fromFileSystem(File input) {
        File indexFile = input.isFile() ? input : new File(input, DEFAULT_INDEX_FILE);
        Path basePath = indexFile.getParentFile().toPath();
        Function<String, InputStream> fileLoader = path -> {
            try {
                return Files.newInputStream(basePath.resolve((String)path), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new SmartcardFactoryException(MessageFormat.format("Unable to load File from {0}", basePath.resolve((String)path)), (Throwable)e);
            }
        };
        Supplier<InputStream> indexSupplier = () -> (InputStream)fileLoader.apply(indexFile.getName());
        List<SmartcardConfigDto> configs = SmartcardFactory.loadConfigs(basePath, indexSupplier);
        return new SmartcardFactory(configs, fileLoader);
    }

    public static SmartcardFactory fromResources() {
        Function<String, InputStream> fileLoader = path -> ResourceLoader.getFileFromResourceAsStream((String)MessageFormat.format("{0}/{1}", DEFAULT_INDEX_DIR, path));
        Supplier<InputStream> indexSupplier = () -> (InputStream)fileLoader.apply(DEFAULT_INDEX_FILE);
        List<SmartcardConfigDto> configs = SmartcardFactory.loadConfigs(Path.of(DEFAULT_INDEX_FILE, new String[0]), indexSupplier);
        return new SmartcardFactory(configs, fileLoader);
    }

    @Generated
    public List<SmartcardConfigDto> getConfigs() {
        return this.configs;
    }
}

