/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.smartcards.SmartcardOwnerData;
import java.text.MessageFormat;
import javax.security.auth.x500.X500Principal;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LdapReader.class);

    private LdapReader() {
        throw new UnsupportedOperationException();
    }

    public static SmartcardOwnerData getOwnerData(X500Principal subject) {
        return LdapReader.getOwnerData(subject.getName());
    }

    public static SmartcardOwnerData getOwnerData(String subject) {
        String[] elements;
        SmartcardOwnerData.Builder builder = SmartcardOwnerData.builder();
        String fixedName = subject.replace("+", ",");
        block25: for (String rdn : elements = fixedName.split(",")) {
            String[] token = rdn.split("=");
            String key = token[0].trim();
            String value = token[1].trim();
            switch (key.toUpperCase()) {
                case "CN": {
                    builder.commonName(value);
                    continue block25;
                }
                case "T": {
                    builder.title(value);
                    continue block25;
                }
                case "GIVENNAME": 
                case "GN": {
                    builder.givenName(value);
                    continue block25;
                }
                case "SURNAME": {
                    builder.surname(value);
                    continue block25;
                }
                case "STREET": {
                    builder.street(value);
                    continue block25;
                }
                case "POSTALCODE": {
                    builder.postalCode(value);
                    continue block25;
                }
                case "O": {
                    builder.organization(value);
                    continue block25;
                }
                case "OU": {
                    builder.organizationUnit(value);
                    continue block25;
                }
                case "L": {
                    builder.locality(value);
                    continue block25;
                }
                case "C": {
                    builder.country(value);
                    continue block25;
                }
                default: {
                    log.trace(MessageFormat.format("ignore key {0} with value {1} in subject {2}", key, value, subject));
                }
            }
        }
        return builder.build();
    }
}

