/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.crypto.certificate.Oid;
import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.SmartcardCertificate;
import de.gematik.bbriccs.smartcards.SmartcardP12;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.cfg.SmartcardConfigDto;
import de.gematik.bbriccs.smartcards.exceptions.InvalidCertificateException;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;

public class EgkP12
extends SmartcardP12
implements Egk {
    private static final Pattern KVNR_PATTERN = Pattern.compile("^([A-Z]\\d{9})$");
    private final String kvnr = this.getOwnerData().getOrganizationUnit().stream().filter(ou -> KVNR_PATTERN.matcher((CharSequence)ou).matches()).findFirst().orElseThrow(() -> new InvalidCertificateException(MessageFormat.format("Authorization Certificate for eGK {0} is missing a valid KVNR", this.getIccsn())));

    public EgkP12(SmartcardConfigDto config, List<SmartcardCertificate> certificates) {
        super(SmartcardType.EGK, config, certificates);
    }

    public List<Oid> getAutOids() {
        return List.of(Oid.OID_EGK_AUT, Oid.OID_EGK_AUT_ALT);
    }

    @Generated
    public String getKvnr() {
        return this.kvnr;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EgkP12)) {
            return false;
        }
        EgkP12 other = (EgkP12)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$kvnr = this.getKvnr();
        String other$kvnr = other.getKvnr();
        return !(this$kvnr == null ? other$kvnr != null : !this$kvnr.equals(other$kvnr));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EgkP12;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $kvnr = this.getKvnr();
        result = result * 59 + ($kvnr == null ? 43 : $kvnr.hashCode());
        return result;
    }
}

