/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards.exceptions;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.crypto.certificate.Oid;
import de.gematik.bbriccs.smartcards.Smartcard;
import java.text.MessageFormat;
import java.util.List;

public class SmartCardKeyNotFoundException
extends RuntimeException {
    public SmartCardKeyNotFoundException(Smartcard smartcard, List<Oid> oids, CryptoSystem cryptoSystem) {
        super(MessageFormat.format("Key with {0} and Algorithm {1} not found for {2}", oids, cryptoSystem, smartcard));
    }

    public SmartCardKeyNotFoundException(Smartcard smartcard) {
        this(smartcard, smartcard.getAutOids());
    }

    public SmartCardKeyNotFoundException(Smartcard smartcard, List<Oid> oids) {
        super(MessageFormat.format("Key with {0} not found for {1}", oids, smartcard));
    }

    public SmartCardKeyNotFoundException(Smartcard smartcard, Oid oid, CryptoSystem crypto) {
        this(smartcard, List.of(oid), crypto);
    }
}

