/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards.exceptions;

import de.gematik.bbriccs.smartcards.Smartcard;
import de.gematik.bbriccs.smartcards.SmartcardType;
import java.text.MessageFormat;

public class CardNotFoundException
extends RuntimeException {
    public CardNotFoundException(String iccsn) {
        super(MessageFormat.format("Smartcard with ICCSN {0} not found", iccsn));
    }

    public CardNotFoundException(SmartcardType type, String iccsn) {
        super(MessageFormat.format("Card of type {0} with ICCSN/KVNR {1} not found", new Object[]{type, iccsn}));
    }

    public <T extends Smartcard> CardNotFoundException(Class<T> type, String iccsn) {
        super(MessageFormat.format("Card of type {0} with ICCSN/KVNR {1} not found", type.getSimpleName(), iccsn));
    }

    public CardNotFoundException(String message, Throwable cause) {
        super(message, cause);
    }
}

