/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.Hba;
import de.gematik.bbriccs.smartcards.Smartcard;
import de.gematik.bbriccs.smartcards.SmcB;
import de.gematik.bbriccs.smartcards.exceptions.InvalidSmartcardTypeException;
import lombok.Generated;

public enum SmartcardType {
    EGK("eGK"),
    HBA("HBA"),
    SMC_B("SMC-B"),
    SMC_KT("SMC-KT");

    private final String name;

    private SmartcardType(String name) {
        this.name = name;
    }

    public static SmartcardType fromString(String type) {
        return switch (type.toLowerCase().strip().replaceAll("[-_]", "")) {
            case "egk" -> EGK;
            case "hba" -> HBA;
            case "smcb" -> SMC_B;
            case "smckt" -> SMC_KT;
            default -> throw new InvalidSmartcardTypeException(type);
        };
    }

    public static <S extends Smartcard> SmartcardType fromImplementationType(Class<S> smartcardClass) {
        if (Egk.class.isAssignableFrom(smartcardClass)) {
            return EGK;
        }
        if (Hba.class.isAssignableFrom(smartcardClass)) {
            return HBA;
        }
        if (SmcB.class.isAssignableFrom(smartcardClass)) {
            return SMC_B;
        }
        throw new InvalidSmartcardTypeException(smartcardClass.getSimpleName());
    }

    public String toString() {
        return this.name;
    }

    @Generated
    public String getName() {
        return this.name;
    }
}

