/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.smartcards.exceptions.SmartcardFactoryException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public class SmartcardOwnerData {
    private final String commonName;
    private final String title;
    private final String givenName;
    private final String surname;
    private final String organization;
    private final List<String> organizationUnit;
    private final String street;
    private final String locality;
    private final String postalCode;
    private final String country;

    private SmartcardOwnerData(Builder builder) {
        this.commonName = builder.commonName;
        this.title = builder.title;
        this.givenName = builder.givenName;
        this.surname = builder.surname;
        this.organization = builder.organization;
        this.organizationUnit = builder.organizationUnit;
        this.street = builder.street;
        this.locality = builder.locality;
        this.postalCode = builder.postalCode;
        this.country = builder.country;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOwnerName() {
        String ret = this.title != null ? this.title + " " : "";
        return ret + MessageFormat.format("{0}, {1}", this.givenName, this.surname);
    }

    public String toString() {
        return this.getOwnerName();
    }

    @Generated
    public String getCommonName() {
        return this.commonName;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getGivenName() {
        return this.givenName;
    }

    @Generated
    public String getSurname() {
        return this.surname;
    }

    @Generated
    public String getOrganization() {
        return this.organization;
    }

    @Generated
    public List<String> getOrganizationUnit() {
        return this.organizationUnit;
    }

    @Generated
    public String getStreet() {
        return this.street;
    }

    @Generated
    public String getLocality() {
        return this.locality;
    }

    @Generated
    public String getPostalCode() {
        return this.postalCode;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    public static class Builder {
        private String commonName;
        private String title;
        private String givenName;
        private String surname;
        private String organization;
        private final List<String> organizationUnit = new LinkedList<String>();
        private String street;
        private String locality;
        private String postalCode;
        private String country;

        public Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = givenName;
            return this;
        }

        public Builder surname(String surname) {
            this.surname = surname;
            return this;
        }

        public Builder organization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder organizationUnit(String organizationUnit) {
            this.organizationUnit.add(organizationUnit);
            return this;
        }

        public Builder street(String street) {
            this.street = street;
            return this;
        }

        public Builder locality(String locality) {
            this.locality = locality;
            return this;
        }

        public Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public SmartcardOwnerData build() {
            if (this.commonName != null && (this.givenName == null || this.surname == null)) {
                String[] commonNameTokens = this.commonName.replace("TEST-ONLY", "").trim().split(" ");
                if (this.givenName == null) {
                    this.givenName = commonNameTokens[0];
                }
                if (this.surname == null) {
                    this.surname = commonNameTokens[commonNameTokens.length - 1];
                }
            } else if (this.commonName == null && this.givenName != null && this.surname != null) {
                this.commonName = MessageFormat.format("{0} {1}", this.givenName, this.surname);
            } else if (this.commonName == null) {
                throw new SmartcardFactoryException(MessageFormat.format("Ownerdata does not have enough information to build the full name of the owner", new Object[0]));
            }
            return new SmartcardOwnerData(this);
        }

        @Generated
        private Builder() {
        }
    }
}

