/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.crypto.CryptoSystem;
import de.gematik.bbriccs.crypto.certificate.Oid;
import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.Hba;
import de.gematik.bbriccs.smartcards.Smartcard;
import de.gematik.bbriccs.smartcards.SmartcardCertificate;
import de.gematik.bbriccs.smartcards.SmartcardExtension;
import de.gematik.bbriccs.smartcards.SmartcardOwnerData;
import de.gematik.bbriccs.smartcards.SmartcardType;
import de.gematik.bbriccs.smartcards.SmcB;
import de.gematik.bbriccs.smartcards.exceptions.InvalidSmartcardTypeException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class SmartcardTypeTest {
    SmartcardTypeTest() {
    }

    @Test
    void shouldGetSmartcardTypeFromString() {
        Map<String, SmartcardType> inputs = Map.of("egk", SmartcardType.EGK, "hba", SmartcardType.HBA, "smcb", SmartcardType.SMC_B, "smc-b", SmartcardType.SMC_B, "smckt", SmartcardType.SMC_KT, "EGK", SmartcardType.EGK, "h-b-a", SmartcardType.HBA, "HbA", SmartcardType.HBA);
        inputs.forEach((k, v) -> Assertions.assertEquals((Object)v, (Object)SmartcardType.fromString((String)k)));
    }

    @Test
    void shouldThrowOnSmartcardTypeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> SmartcardType.fromString(null));
    }

    @Test
    void shouldThrowOnInvalidSmartcardType() {
        List<String> inputs = List.of("smc-a", "SMC-D", "egk2");
        inputs.forEach(input -> Assertions.assertThrows(InvalidSmartcardTypeException.class, () -> SmartcardType.fromString((String)"SMC-D")));
    }

    @ParameterizedTest
    @MethodSource
    void shouldMapSmartcardTypeFromImplementationClass(Class<Smartcard> clazz, SmartcardType expectedType) {
        SmartcardType type = SmartcardType.fromImplementationType(clazz);
        Assertions.assertEquals((Object)expectedType, (Object)type);
    }

    static Stream<Arguments> shouldMapSmartcardTypeFromImplementationClass() {
        return Stream.of(Arguments.of((Object[])new Object[]{Egk.class, SmartcardType.EGK}), Arguments.of((Object[])new Object[]{Hba.class, SmartcardType.HBA}), Arguments.of((Object[])new Object[]{SmcB.class, SmartcardType.SMC_B}));
    }

    @Test
    void shouldThrowOnUnknownSmartcardImplementation() {
        Assertions.assertThrows(InvalidSmartcardTypeException.class, () -> SmartcardType.fromImplementationType(UnknownSmartcard.class));
    }

    @ParameterizedTest
    @MethodSource
    void shouldProvideName(SmartcardType type, String expectedName) {
        Assertions.assertEquals((Object)expectedName, (Object)type.getName());
        Assertions.assertTrue((boolean)type.toString().contains(expectedName));
    }

    static Stream<Arguments> shouldProvideName() {
        return Stream.of(Arguments.of((Object[])new Object[]{SmartcardType.EGK, "eGK"}), Arguments.of((Object[])new Object[]{SmartcardType.HBA, "HBA"}), Arguments.of((Object[])new Object[]{SmartcardType.SMC_B, "SMC-B"}), Arguments.of((Object[])new Object[]{SmartcardType.SMC_KT, "SMC-KT"}));
    }

    private static class UnknownSmartcard
    implements Smartcard {
        protected UnknownSmartcard() {
        }

        public SmartcardCertificate getAutCertificate() {
            return null;
        }

        public Optional<SmartcardCertificate> getAutCertificate(CryptoSystem cryptoSystem) {
            return Optional.empty();
        }

        public PrivateKey getAuthPrivateKey() {
            return null;
        }

        public PublicKey getAuthPublicKey() {
            return null;
        }

        public String getPrivateKeyBase64() {
            return "";
        }

        public List<Oid> getAutOids() {
            return List.of();
        }

        public String getIccsn() {
            return "123";
        }

        public SmartcardType getType() {
            return SmartcardType.SMC_KT;
        }

        public SmartcardOwnerData getOwnerData() {
            return null;
        }

        public Map<String, Object> getExtension() {
            return Map.of();
        }

        public <E extends SmartcardExtension> E getExtensionAs(Class<E> extensionType) {
            return null;
        }
    }
}

