/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.smartcards;

import de.gematik.bbriccs.smartcards.SmartcardOwnerData;
import de.gematik.bbriccs.smartcards.exceptions.SmartcardFactoryException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class SmartcardOwnerDataTest {
    SmartcardOwnerDataTest() {
    }

    @Test
    void shouldComposeOwnerNameWithoutTitle() {
        SmartcardOwnerData ownerData = SmartcardOwnerData.builder().surname("Max").givenName("Mustermann").build();
        Assertions.assertEquals((Object)"Mustermann Max", (Object)ownerData.getCommonName());
        Assertions.assertEquals((Object)"Mustermann, Max", (Object)ownerData.getOwnerName());
        Assertions.assertEquals((Object)"Mustermann, Max", (Object)ownerData.toString());
    }

    @Test
    void shouldComposeOwnerNameWithTitle() {
        SmartcardOwnerData ownerData = SmartcardOwnerData.builder().title("Dr.").surname("Max").givenName("Mustermann").build();
        Assertions.assertEquals((Object)"Mustermann Max", (Object)ownerData.getCommonName());
        Assertions.assertEquals((Object)"Dr. Mustermann, Max", (Object)ownerData.getOwnerName());
        Assertions.assertEquals((Object)"Dr. Mustermann, Max", (Object)ownerData.toString());
    }

    @Test
    void shouldExtractNamesFromCommonName() {
        SmartcardOwnerData ownerData = SmartcardOwnerData.builder().commonName("Max Mustermann").build();
        Assertions.assertEquals((Object)"Max", (Object)ownerData.getGivenName());
        Assertions.assertEquals((Object)"Mustermann", (Object)ownerData.getSurname());
    }

    @Test
    void shouldExtractNamesFromCommonNameWithoutMiddleNames() {
        SmartcardOwnerData ownerData = SmartcardOwnerData.builder().commonName("Max von und zu Mustermann").build();
        Assertions.assertEquals((Object)"Max", (Object)ownerData.getGivenName());
        Assertions.assertEquals((Object)"Mustermann", (Object)ownerData.getSurname());
    }

    @Test
    void shouldExtractGivenNameFromCommonName() {
        SmartcardOwnerData ownerData = SmartcardOwnerData.builder().commonName("Max Mustermann").givenName("Maximilian").build();
        Assertions.assertEquals((Object)"Maximilian", (Object)ownerData.getGivenName());
        Assertions.assertEquals((Object)"Mustermann", (Object)ownerData.getSurname());
    }

    @Test
    void shouldExtractSurnameFromCommonName() {
        SmartcardOwnerData ownerData = SmartcardOwnerData.builder().commonName("Max Mustermann").surname("M\u00fcller").build();
        Assertions.assertEquals((Object)"Max", (Object)ownerData.getGivenName());
        Assertions.assertEquals((Object)"M\u00fcller", (Object)ownerData.getSurname());
    }

    @ParameterizedTest
    @MethodSource
    void shouldThrowOnInsufficientOwnerNameData(Consumer<SmartcardOwnerData.Builder> builderConsumer) {
        SmartcardOwnerData.Builder odb = SmartcardOwnerData.builder();
        builderConsumer.accept(odb);
        Assertions.assertThrows(SmartcardFactoryException.class, () -> ((SmartcardOwnerData.Builder)odb).build());
    }

    static Stream<Arguments> shouldThrowOnInsufficientOwnerNameData() {
        return Stream.of(Arguments.of((Object[])new Object[]{b -> b.givenName("Max")}), Arguments.of((Object[])new Object[]{b -> b.surname("Mustermann")}));
    }
}

