/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.idp;

import de.gematik.bbriccs.rest.fd.FdRequest;
import de.gematik.bbriccs.rest.fd.plugins.RequestHeaderProvider;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.JwtHeaderKey;
import de.gematik.bbriccs.smartcards.Smartcard;
import de.gematik.bbriccs.smartcards.SmartcardCertificate;
import de.gematik.idp.client.IdpClient;
import de.gematik.idp.client.IdpClientRuntimeException;
import de.gematik.idp.client.IdpTokenResult;
import de.gematik.idp.crypto.model.PkiIdentity;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdpTokenHeaderProvider
implements RequestHeaderProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdpTokenHeaderProvider.class);
    private final Supplier<IdpTokenResult> authentication;
    private IdpTokenResult idpToken;
    private Instant idpTokenUpdated;

    private IdpTokenHeaderProvider(Supplier<IdpTokenResult> authentication) {
        this.authentication = authentication;
    }

    public HttpHeader forRequest(FdRequest<? extends Resource, ? extends Resource> request) {
        this.refreshIdpToken();
        String accessKey = this.idpToken.getAccessToken().getRawString();
        return JwtHeaderKey.AUTHORIZATION.createHeader(accessKey);
    }

    private void refreshIdpToken() {
        if (this.idpTokenExpired()) {
            log.info("Refresh the IDP Token");
            try {
                this.idpToken = this.authentication.get();
                this.idpTokenUpdated = Instant.now();
            }
            catch (NullPointerException npe) {
                log.warn("Something went wrong during authentication on IDP");
                throw new IdpClientRuntimeException("Caught NullPointer from IDP-Client", (Exception)npe);
            }
        } else {
            log.info("IDP Token is still valid, no need to refresh");
        }
    }

    private boolean idpTokenExpired() {
        Instant now;
        long diff;
        boolean ret = this.idpToken == null ? true : (diff = Duration.between(this.idpTokenUpdated, now = Instant.now()).getSeconds()) >= (long)this.idpToken.getExpiresIn();
        return ret;
    }

    public static JwtHeaderProviderBuilder withDiscoveryDocumentUrl(String url) {
        return new JwtHeaderProviderBuilder(url);
    }

    public static class JwtHeaderProviderBuilder {
        private final String discoveryDocumentUrl;
        private final Set<String> scopes = new LinkedHashSet<String>();
        private String redirectUrl;
        private String clientId;

        public JwtHeaderProviderBuilder withRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public JwtHeaderProviderBuilder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public JwtHeaderProviderBuilder usingScope(String scope) {
            return this.usingScopes(List.of("openid", scope));
        }

        public JwtHeaderProviderBuilder usingScopes(List<String> scopes) {
            this.scopes.addAll(scopes);
            return this;
        }

        public IdpTokenHeaderProvider authenticateWith(Smartcard smartcard) {
            SmartcardCertificate autCertificate = smartcard.getAutCertificate();
            PkiIdentity pki = PkiIdentity.builder().certificate(autCertificate.getX509Certificate()).privateKey(autCertificate.getPrivateKey()).build();
            return this.authenticateWith(pki);
        }

        public IdpTokenHeaderProvider authenticateWith(PkiIdentity pki) {
            IdpClient idpClient = this.initIdpClient();
            Supplier<IdpTokenResult> authentication = () -> idpClient.login(pki);
            return new IdpTokenHeaderProvider(authentication);
        }

        public IdpTokenHeaderProvider authenticateWith(X509Certificate authPubCert, UnaryOperator<byte[]> challenge) {
            IdpClient idpClient = this.initIdpClient();
            Supplier<IdpTokenResult> authentication = () -> idpClient.login(authPubCert, challenge);
            return new IdpTokenHeaderProvider(authentication);
        }

        private IdpClient initIdpClient() {
            IdpClient idpClient = IdpClient.builder().clientId(this.clientId).redirectUrl(this.redirectUrl).discoveryDocumentUrl(this.discoveryDocumentUrl).scopes(this.scopes).build();
            idpClient.initialize();
            return idpClient;
        }

        @Generated
        private JwtHeaderProviderBuilder(String discoveryDocumentUrl) {
            this.discoveryDocumentUrl = discoveryDocumentUrl;
        }
    }
}

