/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.idp;

import de.gematik.bbriccs.fhir.codec.EmptyResource;
import de.gematik.bbriccs.rest.fd.FdRequest;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.JwtHeaderKey;
import de.gematik.bbriccs.rest.idp.IdpTokenHeaderProvider;
import de.gematik.bbriccs.smartcards.Egk;
import de.gematik.bbriccs.smartcards.Smartcard;
import de.gematik.bbriccs.smartcards.SmartcardArchive;
import de.gematik.bbriccs.smartcards.SmartcardCertificate;
import de.gematik.idp.client.IdpClient;
import de.gematik.idp.client.IdpClientRuntimeException;
import de.gematik.idp.client.IdpTokenResult;
import de.gematik.idp.crypto.EcSignerUtility;
import de.gematik.idp.crypto.RsaSignerUtility;
import de.gematik.idp.crypto.model.PkiIdentity;
import de.gematik.idp.token.JsonWebToken;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.function.UnaryOperator;
import org.hl7.fhir.r4.model.Bundle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class IdpTokenHeaderProviderTest {
    private static SmartcardArchive sca;

    IdpTokenHeaderProviderTest() {
    }

    @BeforeAll
    static void setupSmartcards() {
        sca = SmartcardArchive.fromResources();
    }

    @Test
    void shouldAuthenticateViaSmartcardWithCaching() {
        Egk egk = sca.getEgk(0);
        IdpTokenHeaderProvider.JwtHeaderProviderBuilder pb = IdpTokenHeaderProvider.withDiscoveryDocumentUrl((String)"https://idp-ref.app.ti-dienste.de/.well-known/openid-configuration").withRedirectUrl("https://test-ps.gematik.de/bbriccs").withClientId("bbriccsTestPs").usingScope("bbriccs");
        try (MockedStatic staticMockIdpClient = Mockito.mockStatic(IdpClient.class);){
            IdpClient mockIdpClient = (IdpClient)Mockito.mock(IdpClient.class);
            IdpClient.IdpClientBuilder mockBuilder = (IdpClient.IdpClientBuilder)Mockito.mock(IdpClient.IdpClientBuilder.class);
            Mockito.when((Object)mockBuilder.redirectUrl(Mockito.anyString())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.clientId(Mockito.anyString())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.discoveryDocumentUrl(Mockito.anyString())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.scopes(Mockito.anySet())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.build()).thenReturn((Object)mockIdpClient);
            staticMockIdpClient.when(IdpClient::builder).thenReturn((Object)mockBuilder);
            IdpTokenResult idpTokenResult1 = IdpTokenResult.builder().accessToken(new JsonWebToken("ABC")).build();
            idpTokenResult1.setExpiresIn(1000);
            IdpTokenResult idpTokenResult2 = IdpTokenResult.builder().accessToken(new JsonWebToken("XYZ")).build();
            Mockito.when((Object)mockIdpClient.login((PkiIdentity)Mockito.any())).thenReturn((Object)idpTokenResult1).thenReturn((Object)idpTokenResult2);
            IdpTokenHeaderProvider provider = (IdpTokenHeaderProvider)Assertions.assertDoesNotThrow(() -> pb.authenticateWith((Smartcard)egk));
            FdRequest<EmptyResource, Bundle> request = this.createMockRequest();
            HttpHeader firstHeader = (HttpHeader)Assertions.assertDoesNotThrow(() -> provider.forRequest(request));
            Assertions.assertEquals((Object)JwtHeaderKey.AUTHORIZATION.getKey(), (Object)firstHeader.key());
            Assertions.assertNotNull((Object)firstHeader.value());
            HttpHeader secondHeader = (HttpHeader)Assertions.assertDoesNotThrow(() -> provider.forRequest(request));
            Assertions.assertEquals((Object)firstHeader.value(), (Object)secondHeader.value());
        }
    }

    @Test
    void shouldRefreshIfTokenExpired() {
        Egk egk = sca.getEgk(0);
        IdpTokenHeaderProvider.JwtHeaderProviderBuilder pb = IdpTokenHeaderProvider.withDiscoveryDocumentUrl((String)"https://idp-ref.app.ti-dienste.de/.well-known/openid-configuration").withRedirectUrl("https://test-ps.gematik.de/bbriccs").withClientId("bbriccsTestPs").usingScope("bbriccs");
        try (MockedStatic staticMockIdpClient = Mockito.mockStatic(IdpClient.class);){
            IdpClient mockIdpClient = (IdpClient)Mockito.mock(IdpClient.class);
            IdpClient.IdpClientBuilder mockBuilder = (IdpClient.IdpClientBuilder)Mockito.mock(IdpClient.IdpClientBuilder.class);
            Mockito.when((Object)mockBuilder.redirectUrl(Mockito.anyString())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.clientId(Mockito.anyString())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.discoveryDocumentUrl(Mockito.anyString())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.scopes(Mockito.anySet())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.build()).thenReturn((Object)mockIdpClient);
            staticMockIdpClient.when(IdpClient::builder).thenReturn((Object)mockBuilder);
            IdpTokenResult idpTokenResult1 = IdpTokenResult.builder().accessToken(new JsonWebToken("ABC")).build();
            idpTokenResult1.setExpiresIn(0);
            IdpTokenResult idpTokenResult2 = IdpTokenResult.builder().accessToken(new JsonWebToken("XYZ")).build();
            Mockito.when((Object)mockIdpClient.login((PkiIdentity)Mockito.any())).thenReturn((Object)idpTokenResult1).thenReturn((Object)idpTokenResult2);
            IdpTokenHeaderProvider provider = (IdpTokenHeaderProvider)Assertions.assertDoesNotThrow(() -> pb.authenticateWith((Smartcard)egk));
            FdRequest<EmptyResource, Bundle> request = this.createMockRequest();
            HttpHeader firstHeader = (HttpHeader)Assertions.assertDoesNotThrow(() -> provider.forRequest(request));
            Assertions.assertEquals((Object)JwtHeaderKey.AUTHORIZATION.getKey(), (Object)firstHeader.key());
            Assertions.assertNotNull((Object)firstHeader.value());
            Assertions.assertEquals((Object)"Bearer ABC", (Object)firstHeader.value());
            HttpHeader secondHeader = (HttpHeader)Assertions.assertDoesNotThrow(() -> provider.forRequest(request));
            Assertions.assertNotNull((Object)secondHeader.value());
            Assertions.assertNotEquals((Object)firstHeader.value(), (Object)secondHeader.value());
            Assertions.assertEquals((Object)"Bearer XYZ", (Object)secondHeader.value());
        }
    }

    @Test
    void shouldAuthenticateViaExternalAuthenticate() {
        Egk egk = sca.getEgk(0);
        IdpTokenHeaderProvider.JwtHeaderProviderBuilder pb = IdpTokenHeaderProvider.withDiscoveryDocumentUrl((String)"https://idp-ref.app.ti-dienste.de/.well-known/openid-configuration").withRedirectUrl("https://test-ps.gematik.de/bbriccs").withClientId("bbriccsTestPs").usingScope("bbriccs");
        try (MockedStatic staticMockIdpClient = Mockito.mockStatic(IdpClient.class);){
            IdpClient mockIdpClient = (IdpClient)Mockito.mock(IdpClient.class);
            IdpClient.IdpClientBuilder mockBuilder = (IdpClient.IdpClientBuilder)Mockito.mock(IdpClient.IdpClientBuilder.class);
            Mockito.when((Object)mockBuilder.redirectUrl(Mockito.anyString())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.clientId(Mockito.anyString())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.discoveryDocumentUrl(Mockito.anyString())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.scopes(Mockito.anySet())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.build()).thenReturn((Object)mockIdpClient);
            staticMockIdpClient.when(IdpClient::builder).thenReturn((Object)mockBuilder);
            IdpTokenResult idpTokenResult1 = IdpTokenResult.builder().accessToken(new JsonWebToken("ABC")).build();
            idpTokenResult1.setExpiresIn(1000);
            IdpTokenResult idpTokenResult2 = IdpTokenResult.builder().accessToken(new JsonWebToken("XYZ")).build();
            Mockito.when((Object)mockIdpClient.login((X509Certificate)Mockito.any(), (UnaryOperator)Mockito.any())).thenReturn((Object)idpTokenResult1).thenReturn((Object)idpTokenResult2);
            SmartcardCertificate autCertificate = egk.getAutCertificate();
            PkiIdentity pki = PkiIdentity.builder().certificate(autCertificate.getX509Certificate()).privateKey(autCertificate.getPrivateKey()).build();
            UnaryOperator challenge = tbsData -> pki.getPrivateKey() instanceof RSAPrivateKey ? RsaSignerUtility.createRsaSignature((byte[])tbsData, (PrivateKey)pki.getPrivateKey()) : EcSignerUtility.createEcSignature((byte[])tbsData, (PrivateKey)pki.getPrivateKey());
            IdpTokenHeaderProvider provider = (IdpTokenHeaderProvider)Assertions.assertDoesNotThrow(() -> pb.authenticateWith(autCertificate.getX509Certificate(), challenge));
            FdRequest<EmptyResource, Bundle> request = this.createMockRequest();
            HttpHeader firstHeader = (HttpHeader)Assertions.assertDoesNotThrow(() -> provider.forRequest(request));
            Assertions.assertEquals((Object)JwtHeaderKey.AUTHORIZATION.getKey(), (Object)firstHeader.key());
            Assertions.assertNotNull((Object)firstHeader.value());
            HttpHeader secondHeader = (HttpHeader)Assertions.assertDoesNotThrow(() -> provider.forRequest(request));
            Assertions.assertEquals((Object)firstHeader.value(), (Object)secondHeader.value());
        }
    }

    @Test
    void shouldCatchNPEsFromIdpClient() {
        Egk egk = sca.getEgk(0);
        IdpTokenHeaderProvider.JwtHeaderProviderBuilder pb = IdpTokenHeaderProvider.withDiscoveryDocumentUrl((String)"https://idp-ref.app.ti-dienste.de/.well-known/openid-configuration").withRedirectUrl("https://test-ps.gematik.de/bbriccs").withClientId("bbriccsTestPs").usingScope("bbriccs");
        try (MockedStatic staticMockIdpClient = Mockito.mockStatic(IdpClient.class);){
            IdpClient mockIdpClient = (IdpClient)Mockito.mock(IdpClient.class);
            IdpClient.IdpClientBuilder mockBuilder = (IdpClient.IdpClientBuilder)Mockito.mock(IdpClient.IdpClientBuilder.class);
            Mockito.when((Object)mockBuilder.redirectUrl(Mockito.anyString())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.clientId(Mockito.anyString())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.discoveryDocumentUrl(Mockito.anyString())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.scopes(Mockito.anySet())).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockBuilder.build()).thenReturn((Object)mockIdpClient);
            staticMockIdpClient.when(IdpClient::builder).thenReturn((Object)mockBuilder);
            Mockito.when((Object)mockIdpClient.login((PkiIdentity)Mockito.any())).thenThrow(NullPointerException.class);
            IdpTokenHeaderProvider provider = (IdpTokenHeaderProvider)Assertions.assertDoesNotThrow(() -> pb.authenticateWith((Smartcard)egk));
            FdRequest<EmptyResource, Bundle> request = this.createMockRequest();
            Assertions.assertThrows(IdpClientRuntimeException.class, () -> provider.forRequest(request));
        }
    }

    private FdRequest<EmptyResource, Bundle> createMockRequest() {
        return (FdRequest)Mockito.mock(FdRequest.class);
    }
}

