/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.junit5.WireMockTest;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import de.gematik.bbriccs.rest.HttpBClient;
import de.gematik.bbriccs.rest.HttpBRequest;
import de.gematik.bbriccs.rest.HttpBResponse;
import de.gematik.bbriccs.rest.HttpRequestMethod;
import de.gematik.bbriccs.rest.RestClient;
import de.gematik.bbriccs.rest.headers.AuthHttpHeaderKey;
import de.gematik.bbriccs.rest.plugins.HttpBObserver;
import de.gematik.bbriccs.rest.tls.EmptyTrustManager;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

@WireMockTest
class RestClientTest {
    @RegisterExtension
    static WireMockExtension wm1 = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort()).build();
    private static String url;
    private final String apiKey = "test-api-key";

    RestClientTest() {
    }

    @BeforeAll
    static void setup() {
        int port = wm1.getPort();
        url = "http://localhost:" + port;
    }

    private void prepareGetResponse(String testUrl, byte[] resBody) {
        wm1.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)testUrl)).withHeader(AuthHttpHeaderKey.X_API_KEY.getKey(), WireMock.equalTo((String)"test-api-key")).willReturn(WireMock.aResponse().withBody(resBody)));
        wm1.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)testUrl)).withHeader(AuthHttpHeaderKey.X_API_KEY.getKey(), WireMock.not((StringValuePattern)WireMock.equalTo((String)"test-api-key"))).willReturn(WireMock.aResponse().withStatus(403).withBody("Forbidden")));
    }

    private void preparePostResponse(String testUrl, byte[] resBody) {
        wm1.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)testUrl)).withHeader(AuthHttpHeaderKey.X_API_KEY.getKey(), WireMock.equalTo((String)"test-api-key")).withRequestBody((ContentPattern)WireMock.equalTo((String)"Body Payload")).willReturn(WireMock.aResponse().withBody(resBody)));
        wm1.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)testUrl)).withHeader(AuthHttpHeaderKey.X_API_KEY.getKey(), WireMock.not((StringValuePattern)WireMock.equalTo((String)"test-api-key"))).willReturn(WireMock.aResponse().withStatus(403).withBody("Forbidden")));
    }

    @Test
    void shouldMakeSimpleCall() {
        this.preparePostResponse("/test", "Hello, World!".getBytes());
        HttpBClient client = RestClient.forUrl((String)url).usingApiKey("test-api-key").asUserAgent("Bbriccs-Agent").withoutTlsVerification().init();
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.POST, "/test", "Body Payload");
        HttpBResponse response = (HttpBResponse)Assertions.assertDoesNotThrow(() -> client.send(request));
        Assertions.assertEquals((int)200, (int)response.statusCode());
        Assertions.assertEquals((Object)"Hello, World!", (Object)response.bodyAsString());
        Assertions.assertDoesNotThrow(() -> ((HttpBClient)client).shutDown());
    }

    @Test
    void shouldDetectErrorResponseOnInvalidApiKey() {
        this.prepareGetResponse("/test", "Hello, World!".getBytes());
        HttpBClient client = RestClient.forUrl((String)url).usingApiKey("invalid-api-key").asUserAgent("Bbriccs-Agent").withHeader("X-user", "abc").withHeaders(List.of()).withoutTlsVerification().init();
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.GET, "/test");
        HttpBResponse response = (HttpBResponse)Assertions.assertDoesNotThrow(() -> client.send(request));
        Assertions.assertEquals((int)403, (int)response.statusCode());
        Assertions.assertEquals((Object)"Forbidden", (Object)response.bodyAsString());
        Assertions.assertDoesNotThrow(() -> ((HttpBClient)client).shutDown());
    }

    @Test
    void shouldServeObserverOk() {
        this.prepareGetResponse("/test", "Hello, World!".getBytes());
        ReqResObserver httpBop = new ReqResObserver();
        HttpBClient client = RestClient.forUrl((String)url).usingApiKey("test-api-key").asUserAgent("Bbriccs-Agent").register((HttpBObserver)httpBop).withTlsVerification((X509TrustManager)new EmptyTrustManager()).init();
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.GET, "/test");
        HttpBResponse response = (HttpBResponse)Assertions.assertDoesNotThrow(() -> client.send(request));
        Assertions.assertEquals((int)200, (int)response.statusCode());
        Assertions.assertEquals((Object)"Hello, World!", (Object)response.bodyAsString());
        System.out.println(MessageFormat.format("Spend some time to serve observers for response {0}", response.statusCode()));
        Assertions.assertEquals((int)1, (int)httpBop.requests.size());
        Assertions.assertEquals((int)1, (int)httpBop.responses.size());
        Assertions.assertDoesNotThrow(() -> ((HttpBClient)client).shutDown());
    }

    @Test
    void shouldRethrowSneakyExceptionFromSSLContext() {
        RestClient.RestClientBuilder vauBuilder = RestClient.forUrl((String)url);
        try (MockedStatic mockSslContext = Mockito.mockStatic(SSLContext.class);){
            mockSslContext.when(() -> SSLContext.getInstance("TLS")).thenThrow(NoSuchAlgorithmException.class);
            Assertions.assertThrows(NoSuchAlgorithmException.class, () -> ((RestClient.RestClientBuilder)vauBuilder).withoutTlsVerification());
        }
    }

    private static class ReqResObserver
    implements HttpBObserver {
        private final List<HttpBRequest> requests = new LinkedList<HttpBRequest>();
        private final List<HttpBResponse> responses = new LinkedList<HttpBResponse>();

        private ReqResObserver() {
        }

        public void onRequest(HttpBRequest request) {
            this.requests.add(request);
        }

        public void onResponse(HttpBResponse response) {
            this.responses.add(response);
        }
    }
}

