/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest;

import de.gematik.bbriccs.rest.HttpBClient;
import de.gematik.bbriccs.rest.HttpBRequest;
import de.gematik.bbriccs.rest.HttpBResponse;
import de.gematik.bbriccs.rest.HttpVersion;
import de.gematik.bbriccs.rest.headers.AuthHttpHeaderKey;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.StandardHttpHeaderKey;
import de.gematik.bbriccs.rest.plugins.HttpBObserver;
import de.gematik.bbriccs.rest.plugins.HttpBRequestObserver;
import de.gematik.bbriccs.rest.plugins.HttpBResponseObserver;
import de.gematik.bbriccs.rest.plugins.RestObserverManager;
import de.gematik.bbriccs.rest.tls.EmptyTrustManager;
import jakarta.annotation.Nullable;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kong.unirest.core.HttpRequest;
import kong.unirest.core.HttpResponse;
import kong.unirest.core.Proxy;
import kong.unirest.core.Unirest;
import kong.unirest.core.UnirestInstance;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient
implements HttpBClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestClient.class);
    private final UnirestInstance unirest;
    private final String url;
    private final List<HttpHeader> staticHeader;
    private final RestObserverManager restObserver;

    private RestClient(RestClientBuilder builder) {
        this.unirest = builder.unirest;
        this.url = builder.url;
        this.staticHeader = builder.headers;
        this.restObserver = builder.observerBuilder.build();
    }

    public static RestClientBuilder forUrl(String url) {
        return new RestClientBuilder(url);
    }

    public void shutDown() {
        this.unirest.close();
    }

    public HttpBResponse send(HttpBRequest bRequest) {
        log.trace(MessageFormat.format("Send HTTP Request:\n----------\n{0}\n----------", bRequest));
        this.restObserver.serveRequestObservers(bRequest);
        String requestUrl = MessageFormat.format("{0}{1}", this.url, bRequest.urlPath());
        Object httpRequest = bRequest.method().allowedToHaveBody() ? this.unirest.request(bRequest.method().name(), requestUrl).body(bRequest.body()) : this.unirest.request(bRequest.method().name(), requestUrl);
        this.staticHeader.forEach(arg_0 -> RestClient.lambda$send$0((HttpRequest)httpRequest, arg_0));
        bRequest.headers().forEach(arg_0 -> RestClient.lambda$send$1((HttpRequest)httpRequest, arg_0));
        HttpResponse httpResponse = httpRequest.asBytes();
        List<HttpHeader> responseHeaders = httpResponse.getHeaders().all().stream().map(h -> new HttpHeader(h.getName(), h.getValue())).toList();
        HttpBResponse bResponse = new HttpBResponse(HttpVersion.HTTP_1_1, httpResponse.getStatus(), responseHeaders, (byte[])httpResponse.getBody());
        this.restObserver.serveResponseObservers(bResponse);
        return bResponse;
    }

    private static /* synthetic */ void lambda$send$1(HttpRequest httpRequest, HttpHeader h) {
        httpRequest.header(h.key(), h.value());
    }

    private static /* synthetic */ void lambda$send$0(HttpRequest httpRequest, HttpHeader h) {
        httpRequest.header(h.key(), h.value());
    }

    public static class RestClientBuilder {
        private final String url;
        private final List<HttpHeader> headers;
        private final RestObserverManager.RestObserverBuilder observerBuilder = new RestObserverManager.RestObserverBuilder();
        private UnirestInstance unirest;
        @Nullable
        private Proxy proxy;

        private RestClientBuilder(String url) {
            this.url = url;
            this.headers = new LinkedList<HttpHeader>();
        }

        public RestClientBuilder usingAuthorizationKey(String apiKey) {
            return this.withHeader(AuthHttpHeaderKey.X_AUTHORIZATION.createHeader(apiKey));
        }

        public RestClientBuilder usingApiKey(String apiKey) {
            return this.withHeader(AuthHttpHeaderKey.X_API_KEY.createHeader(apiKey));
        }

        public RestClientBuilder asUserAgent(String userAgent) {
            return this.withHeader(StandardHttpHeaderKey.USER_AGENT.createHeader(userAgent));
        }

        public RestClientBuilder withHeader(String key, String value) {
            return this.withHeader(new HttpHeader(key, value));
        }

        public RestClientBuilder withHeader(HttpHeader header) {
            this.headers.add(header);
            return this;
        }

        public RestClientBuilder withHeaders(List<HttpHeader> httpHeaders) {
            this.headers.addAll(httpHeaders);
            return this;
        }

        public RestClientBuilder registerForRequests(HttpBRequestObserver ro) {
            this.observerBuilder.registerForRequests(ro);
            return this;
        }

        public RestClientBuilder registerForResponses(HttpBResponseObserver ro) {
            this.observerBuilder.registerForResponses(ro);
            return this;
        }

        public RestClientBuilder register(HttpBObserver rro) {
            return this.registerForRequests((HttpBRequestObserver)rro).registerForResponses((HttpBResponseObserver)rro);
        }

        public RestClientBuilder usingProxy(String hostName, int port) {
            this.proxy = new Proxy(hostName, Integer.valueOf(port));
            return this;
        }

        public RestClientBuilder usingProxy(String hostName, int port, String userName, String password) {
            this.proxy = new Proxy(hostName, Integer.valueOf(port), userName, password);
            return this;
        }

        public RestClient withoutTlsVerification() {
            EmptyTrustManager trustManager = new EmptyTrustManager();
            return this.withTlsVerification(false, (X509TrustManager)trustManager);
        }

        public RestClient withTlsVerification(X509TrustManager trustManager) {
            return this.withTlsVerification(true, trustManager);
        }

        public RestClient withTlsVerification(SSLContext sslCtx) {
            return this.withTlsVerification(true, sslCtx);
        }

        public RestClient withTlsVerification(boolean verifySsl, SSLContext sslCtx) {
            this.unirest = Unirest.spawnInstance();
            this.unirest.config().verifySsl(verifySsl).sslContext(sslCtx);
            Optional.ofNullable(this.proxy).ifPresent(p -> this.unirest.config().proxy(p));
            return new RestClient(this);
        }

        private RestClient withTlsVerification(boolean verifySsl, X509TrustManager trustManager) {
            SSLContext sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(null, new TrustManager[]{trustManager}, new SecureRandom());
            return this.withTlsVerification(verifySsl, sslCtx);
        }
    }
}

