/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.plugins;

import de.gematik.bbriccs.rest.HttpBRequest;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.StandardHttpHeaderKey;
import de.gematik.bbriccs.rest.plugins.BasicHeaderProvider;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BasicHeaderProviderTest {
    BasicHeaderProviderTest() {
    }

    @Test
    void shouldProvideFixedValueHeader() {
        HttpHeader header = HttpHeader.accept((String)"text/plain");
        BasicHeaderProvider fhvp = BasicHeaderProvider.forStaticHeader((HttpHeader)header);
        HttpHeader header2 = fhvp.forRequest(null);
        Assertions.assertEquals((Object)header, (Object)header2);
    }

    @Test
    void shouldProvideDynamicDateHeader() {
        BasicHeaderProvider fhvp = BasicHeaderProvider.forDate();
        HttpHeader header1 = fhvp.forRequest(null);
        Assertions.assertEquals((Object)StandardHttpHeaderKey.DATE.getKey(), (Object)header1.key());
        Assertions.assertDoesNotThrow(() -> ZonedDateTime.parse(header1.value(), DateTimeFormatter.RFC_1123_DATE_TIME));
    }

    @Test
    void shouldProvideDynamicXRequestIdHeader() {
        BasicHeaderProvider fhvp = BasicHeaderProvider.forXRequestId();
        HttpHeader header1 = fhvp.forRequest(null);
        Assertions.assertEquals((Object)"x-request-id", (Object)header1.key());
        Assertions.assertDoesNotThrow(() -> UUID.fromString(header1.value()));
    }

    @Test
    void shouldCalculateContentLengthHeader() {
        BasicHeaderProvider fhvp = BasicHeaderProvider.forAutoContentLength();
        HttpBRequest request = HttpBRequest.get().withPayload("hello".getBytes(StandardCharsets.UTF_8));
        HttpHeader header1 = fhvp.forRequest(request);
        Assertions.assertNotNull((Object)header1);
        Assertions.assertEquals((Object)"Content-Length", (Object)header1.key());
        Assertions.assertEquals((Object)"5", (Object)header1.value());
    }

    @Test
    void shouldOmitContentLengthZero() {
        BasicHeaderProvider fhvp = BasicHeaderProvider.forAutoContentLength();
        HttpBRequest request = HttpBRequest.get().withoutPayload();
        HttpHeader header1 = fhvp.forRequest(request);
        Assertions.assertNull((Object)header1);
    }

    @Test
    void shouldNotOmitContentLengthZero() {
        BasicHeaderProvider fhvp = BasicHeaderProvider.forAutoContentLength((boolean)false);
        HttpBRequest request = HttpBRequest.get().withoutPayload();
        HttpHeader header1 = fhvp.forRequest(request);
        Assertions.assertNotNull((Object)header1);
        Assertions.assertEquals((Object)"Content-Length", (Object)header1.key());
        Assertions.assertEquals((Object)"0", (Object)header1.value());
    }
}

