/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.headers;

import com.google.common.net.MediaType;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.StandardHttpHeaderKey;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HttpHeaderTest {
    HttpHeaderTest() {
    }

    @Test
    void shouldBuildContentTypeHeader() {
        HttpHeader header = HttpHeader.forContentType((MediaType)MediaType.JSON_UTF_8);
        Assertions.assertEquals((Object)"Content-Type", (Object)header.key());
        Assertions.assertEquals((Object)"Content-Type: application/json; charset=utf-8", (Object)header.toString());
    }

    @Test
    void shouldBuildContentLengthHeader() {
        HttpHeader header = HttpHeader.forContentLength((int)42);
        Assertions.assertEquals((Object)"Content-Length", (Object)header.key());
        Assertions.assertEquals((Object)"42", (Object)header.value());
    }

    @Test
    void shouldBuildUserAgentHeader() {
        HttpHeader header = HttpHeader.forUserAgent((String)"Gematik UA");
        Assertions.assertEquals((Object)"User-Agent", (Object)header.key());
        Assertions.assertEquals((Object)"Gematik UA", (Object)header.value());
    }

    @Test
    void shouldBuildRfcCompliantDateHeader() {
        ZonedDateTime zdt = LocalDateTime.of(1994, Month.NOVEMBER, 6, 8, 49, 37).atZone(ZoneId.of("GMT"));
        HttpHeader header = HttpHeader.forDate((ZonedDateTime)zdt);
        Assertions.assertEquals((Object)"Date", (Object)header.key());
        Assertions.assertEquals((Object)"Sun, 6 Nov 1994 08:49:37 GMT", (Object)header.value());
    }

    @Test
    void shouldBuildDateHeaderForSystemDefaultZoneId() {
        LocalDateTime ldt = LocalDateTime.now();
        String expectation = ZonedDateTime.of(ldt, ZoneId.systemDefault()).format(DateTimeFormatter.RFC_1123_DATE_TIME);
        HttpHeader header = HttpHeader.forDate((LocalDateTime)ldt);
        Assertions.assertEquals((Object)"Date", (Object)header.key());
        Assertions.assertEquals((Object)expectation, (Object)header.value());
    }

    @Test
    void shouldApplyHeaderOnBiConsumer() {
        HashMap map = new HashMap();
        StandardHttpHeaderKey.ACCEPT.createHeader("application/json").apply(map::put);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey(StandardHttpHeaderKey.ACCEPT.getKey()));
        Assertions.assertEquals((Object)"application/json", map.get(StandardHttpHeaderKey.ACCEPT.getKey()));
    }

    @Test
    void shouldApplyHeaderKeyValueOnBiConsumer() {
        HashMap map = new HashMap();
        StandardHttpHeaderKey.ACCEPT.apply("application/json", map::put);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertTrue((boolean)map.containsKey(StandardHttpHeaderKey.ACCEPT.getKey()));
        Assertions.assertEquals((Object)"application/json", map.get(StandardHttpHeaderKey.ACCEPT.getKey()));
    }

    @Test
    void shouldCreateHeadersFromMap() {
        Map<String, String> map = Map.of("Accept", "application/json", "Content-Type", "application/xml");
        List headers = HttpHeader.from(map);
        Assertions.assertEquals((int)2, (int)headers.size());
    }
}

