/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest;

import de.gematik.bbriccs.rest.HttpVersion;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;

class HttpVersionTest {
    HttpVersionTest() {
    }

    @ParameterizedTest
    @MethodSource
    void shouldParseHttpVersionFromString(String input, HttpVersion expected) {
        HttpVersion actualVersion = HttpVersion.fromString((String)input);
        Assertions.assertEquals((Object)expected, (Object)actualVersion);
        Assertions.assertEquals((Object)actualVersion.name(), (Object)actualVersion.asVersion().name());
    }

    static Stream<Arguments> shouldParseHttpVersionFromString() {
        return Stream.of(Arguments.of((Object[])new Object[]{"HTTP/1.1", HttpVersion.HTTP_1_1}), Arguments.of((Object[])new Object[]{"HTTP/2", HttpVersion.HTTP_2}));
    }

    @ParameterizedTest
    @ValueSource(strings={"HTTP/3", "HTTP/1", "http"})
    @NullSource
    void shouldThrowOnInvalidHttpVersion(String input) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpVersion.fromString((String)input));
    }
}

