/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest;

import de.gematik.bbriccs.rest.HttpBRequest;
import de.gematik.bbriccs.rest.HttpHeaderKey;
import de.gematik.bbriccs.rest.HttpVersion;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.JwtHeaderKey;
import de.gematik.bbriccs.rest.headers.StandardHttpHeaderKey;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HttpBRequestTest {
    HttpBRequestTest() {
    }

    @Test
    void shouldNotThrowOnNullBody01() {
        byte[] nullBody = null;
        HttpBRequest request = HttpBRequest.get().version(HttpVersion.HTTP_1_1).urlPath("a/b/c").withPayload(nullBody);
        Assertions.assertNotNull((Object)request.body());
        Assertions.assertEquals((int)0, (int)request.body().length);
        Assertions.assertTrue((boolean)request.isEmptyBody());
        Assertions.assertEquals((Object)"", (Object)request.bodyAsString());
    }

    @Test
    void shouldNotThrowOnNullBody02() {
        String nullBody = null;
        HttpBRequest request = HttpBRequest.get().urlPath("a/b/c").withPayload(nullBody);
        Assertions.assertNotNull((Object)request.body());
        Assertions.assertEquals((int)0, (int)request.body().length);
        Assertions.assertTrue((boolean)request.isEmptyBody());
        Assertions.assertEquals((Object)"", (Object)request.bodyAsString());
    }

    @Test
    void shouldNotThrowOnEmptyBody() {
        byte[] emptyBody = new byte[]{};
        HttpBRequest request = HttpBRequest.patch().urlPath("a/b/c").withPayload(emptyBody);
        Assertions.assertNotNull((Object)request.body());
        Assertions.assertTrue((boolean)request.isEmptyBody());
        Assertions.assertEquals((Object)"", (Object)request.bodyAsString());
    }

    @Test
    void shouldNotThrowOnEmptyBody02() {
        HttpBRequest request = HttpBRequest.get().urlPath("a/b/c").headers(new HttpHeader[]{StandardHttpHeaderKey.USER_AGENT.createHeader("bbriccs")}).withoutPayload();
        Assertions.assertNotNull((Object)request.body());
        Assertions.assertTrue((boolean)request.isEmptyBody());
        Assertions.assertEquals((Object)"", (Object)request.bodyAsString());
    }

    @Test
    void shouldEncodeBodyAsString() {
        String body = "HelloWorld";
        HttpBRequest request = HttpBRequest.post().urlPath("a/b/c").withPayload("HelloWorld");
        Assertions.assertNotNull((Object)request.body());
        Assertions.assertFalse((boolean)request.isEmptyBody());
        Assertions.assertEquals((Object)"HelloWorld", (Object)request.bodyAsString());
        Assertions.assertTrue((boolean)request.getBearerToken().isEmpty());
    }

    @Test
    void shouldExtractBearerToken() {
        byte[] body = "HelloWorld".getBytes(StandardCharsets.UTF_8);
        HttpBRequest request = HttpBRequest.put().urlPath("a/b/c").headers(new HttpHeader[]{JwtHeaderKey.AUTHORIZATION.createHeader("ABC")}).withPayload(body);
        Optional bearer = request.getBearerToken();
        Assertions.assertTrue((boolean)bearer.isPresent());
        Assertions.assertEquals((Object)"ABC", bearer.get());
    }

    @Test
    void shouldNotOverwriteExistingHeader() {
        HttpBRequest request = HttpBRequest.get().urlPath("a/b/c").headers(new HttpHeader[]{StandardHttpHeaderKey.USER_AGENT.createHeader("ABC")}).withoutPayload();
        request.addIfAbsentHeader(new HttpHeader[]{StandardHttpHeaderKey.USER_AGENT.createHeader("XYZ")});
        Assertions.assertTrue((boolean)request.hasHeader((HttpHeaderKey)StandardHttpHeaderKey.USER_AGENT));
        Assertions.assertEquals((int)1, (int)request.headerValues((HttpHeaderKey)StandardHttpHeaderKey.USER_AGENT).size());
        Assertions.assertEquals((Object)"ABC", (Object)request.headerValue((HttpHeaderKey)StandardHttpHeaderKey.USER_AGENT));
    }

    @Test
    void shouldSetAbsentHeader() {
        HttpBRequest request = HttpBRequest.get().urlPath("a/b/c").withoutPayload();
        request.addIfAbsentHeader(new HttpHeader[]{StandardHttpHeaderKey.USER_AGENT.createHeader("XYZ")});
        Assertions.assertTrue((boolean)request.hasHeader((HttpHeaderKey)StandardHttpHeaderKey.USER_AGENT));
        Assertions.assertEquals((int)1, (int)request.headerValues((HttpHeaderKey)StandardHttpHeaderKey.USER_AGENT).size());
        Assertions.assertEquals((Object)"XYZ", (Object)request.headerValue((HttpHeaderKey)StandardHttpHeaderKey.USER_AGENT));
    }

    @Test
    void shouldRemoveExistingHeader() {
        HttpBRequest request = HttpBRequest.get().urlPath("a/b/c").headers(new HttpHeader[]{StandardHttpHeaderKey.USER_AGENT.createHeader("ABC")}).withoutPayload();
        request.addIfAbsentHeader(new HttpHeader[]{StandardHttpHeaderKey.USER_AGENT.createHeader("")});
        Assertions.assertFalse((boolean)request.hasHeader((HttpHeaderKey)StandardHttpHeaderKey.USER_AGENT));
        Assertions.assertEquals((int)0, (int)request.headerValues((HttpHeaderKey)StandardHttpHeaderKey.USER_AGENT).size());
        Assertions.assertEquals((Object)"", (Object)request.headerValue((HttpHeaderKey)StandardHttpHeaderKey.USER_AGENT));
    }
}

