/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest;

import de.gematik.bbriccs.rest.HttpBEntity;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record HttpBResponse(String protocol, int statusCode, List<HttpHeader> headers, byte[] body) implements HttpBEntity
{
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpBResponse.class);
    private static final String DEFAULT_PROTOCOL = "HTTP/1.1";

    public HttpBResponse {
        if (body == null) {
            body = new byte[]{};
        }
    }

    public HttpBResponse(int statusCode, List<HttpHeader> headers, byte[] body) {
        this(DEFAULT_PROTOCOL, statusCode, headers, body);
    }

    public HttpBResponse(int statusCode, List<HttpHeader> headers, String body) {
        this(DEFAULT_PROTOCOL, statusCode, headers, body);
    }

    public HttpBResponse(int statusCode, List<HttpHeader> headers) {
        this(DEFAULT_PROTOCOL, statusCode, headers, new byte[0]);
    }

    public HttpBResponse(String protocol, int statusCode, List<HttpHeader> headers, String body) {
        this(protocol, statusCode, headers, Optional.ofNullable(body).map(b -> b.getBytes(StandardCharsets.UTF_8)).orElse(new byte[0]));
    }

    public HttpBResponse(String protocol, int statusCode, List<HttpHeader> headers) {
        this(protocol, statusCode, headers, new byte[0]);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpBResponse that = (HttpBResponse)o;
        return this.statusCode == that.statusCode && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.headers, that.headers) && Arrays.equals(this.body, that.body);
    }

    @Override
    @Generated
    public int hashCode() {
        int result = Objects.hash(this.protocol, this.statusCode, this.headers);
        result = 31 * result + Arrays.hashCode(this.body);
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "HttpResponse{protocol='" + this.protocol + "', statusCode=" + this.statusCode + ", headers=" + this.headers + "', body=" + this.body.length + " Bytes}";
    }
}

