/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest;

import de.gematik.bbriccs.rest.HttpBEntity;
import de.gematik.bbriccs.rest.HttpRequestMethod;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.JwtHeaderKey;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public record HttpBRequest(HttpRequestMethod method, String urlPath, List<HttpHeader> headers, byte[] body) implements HttpBEntity
{
    public HttpBRequest {
        if (body == null) {
            body = new byte[]{};
        }
    }

    public HttpBRequest(HttpRequestMethod method, String urlPath) {
        this(method, urlPath, List.of(), new byte[0]);
    }

    public HttpBRequest(HttpRequestMethod method, String urlPath, String body) {
        this(method, urlPath, List.of(), body);
    }

    public HttpBRequest(HttpRequestMethod method, String urlPath, byte[] body) {
        this(method, urlPath, List.of(), body);
    }

    public HttpBRequest(HttpRequestMethod method, String urlPath, HttpHeader header, String body) {
        this(method, urlPath, List.of(header), body);
    }

    public HttpBRequest(HttpRequestMethod method, String urlPath, HttpHeader header, byte[] body) {
        this(method, urlPath, List.of(header), body);
    }

    public HttpBRequest(HttpRequestMethod method, String urlPath, List<HttpHeader> headers, String body) {
        this(method, urlPath, headers, Optional.ofNullable(body).map(b -> b.getBytes(StandardCharsets.UTF_8)).orElse(new byte[0]));
    }

    public Optional<String> getBearerToken() {
        return this.headers.stream().filter(h -> h.key().equalsIgnoreCase(JwtHeaderKey.AUTHORIZATION.getKey())).map(HttpHeader::value).map(v -> v.replace("Bearer ", "")).findFirst();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpBRequest that = (HttpBRequest)o;
        return this.method == that.method && Objects.equals(this.urlPath, that.urlPath) && Objects.equals(this.headers, that.headers) && Arrays.equals(this.body, that.body);
    }

    @Override
    @Generated
    public int hashCode() {
        int result = Objects.hash(new Object[]{this.method, this.urlPath, this.headers});
        result = 31 * result + Arrays.hashCode(this.body);
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "HttpRequest{method=" + this.method + ", urlPath='" + this.urlPath + "', headers=" + this.headers + "', body=" + this.body.length + " Bytes}";
    }
}

