/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.plugins;

import de.gematik.bbriccs.rest.HttpBRequest;
import de.gematik.bbriccs.rest.HttpBResponse;
import de.gematik.bbriccs.rest.plugins.HttpBRequestObserver;
import de.gematik.bbriccs.rest.plugins.HttpBResponseObserver;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class RestObserverManager {
    private final List<HttpBRequestObserver> requestObservers;
    private final List<HttpBResponseObserver> responseObservers;

    protected RestObserverManager(RestObserverBuilder builder) {
        this.requestObservers = builder.requestObservers;
        this.responseObservers = builder.responseObservers;
    }

    public void serveRequestObservers(HttpBRequest request) {
        if (!this.requestObservers.isEmpty()) {
            this.requestObservers.parallelStream().forEach(ro -> CompletableFuture.runAsync(() -> ro.onRequest(request)).join());
        }
    }

    public void serveResponseObservers(HttpBResponse response) {
        if (!this.responseObservers.isEmpty()) {
            this.responseObservers.parallelStream().forEach(ro -> CompletableFuture.runAsync(() -> ro.onResponse(response)).join());
        }
    }

    public static class RestObserverBuilder {
        private final List<HttpBRequestObserver> requestObservers = new LinkedList<HttpBRequestObserver>();
        private final List<HttpBResponseObserver> responseObservers = new LinkedList<HttpBResponseObserver>();

        public RestObserverBuilder registerForRequests(HttpBRequestObserver ro) {
            this.requestObservers.add(ro);
            return this;
        }

        public RestObserverBuilder registerForResponses(HttpBResponseObserver ro) {
            this.responseObservers.add(ro);
            return this;
        }

        public RestObserverManager build() {
            return new RestObserverManager(this);
        }
    }
}

