/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.headers;

import com.google.common.net.MediaType;
import de.gematik.bbriccs.rest.headers.StandardHttpHeaderKey;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public record HttpHeader(String key, String value) {
    public void apply(BiConsumer<String, String> headerConsumer) {
        headerConsumer.accept(this.key, this.value);
    }

    public static HttpHeader forContentLength(int length) {
        return StandardHttpHeaderKey.CONTENT_LENGTH.createHeader(String.valueOf(length));
    }

    public static HttpHeader forContentType(MediaType mediaType) {
        return HttpHeader.forContentType(mediaType.toString());
    }

    public static HttpHeader forContentType(String type) {
        return StandardHttpHeaderKey.CONTENT_TYPE.createHeader(type);
    }

    public static HttpHeader forUserAgent(String userAgent) {
        return StandardHttpHeaderKey.USER_AGENT.createHeader(userAgent);
    }

    public static HttpHeader forDate(LocalDateTime dateTime) {
        return HttpHeader.forDate(dateTime.atZone(ZoneId.systemDefault()));
    }

    public static HttpHeader forDate(ZonedDateTime dateTime) {
        return HttpHeader.forDate(dateTime.format(DateTimeFormatter.RFC_1123_DATE_TIME));
    }

    public static HttpHeader forDate(String date) {
        return StandardHttpHeaderKey.DATE.createHeader(date);
    }

    public static List<HttpHeader> from(Map<String, String> headerMap) {
        return headerMap.entrySet().stream().map(es -> new HttpHeader((String)es.getKey(), (String)es.getValue())).toList();
    }
}

