/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest;

import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;

public enum HttpVersion {
    HTTP_1_1("HTTP/1.1"),
    HTTP_2("HTTP/2");

    public final String version;

    public String toString() {
        return this.version;
    }

    public static HttpVersion fromString(String version) {
        return HttpVersion.optionalFromString(version).orElseThrow(() -> new IllegalArgumentException("Unknown HTTP version: " + version));
    }

    public static Optional<HttpVersion> optionalFromString(String version) {
        return Arrays.stream(HttpVersion.values()).filter(v -> v.version.equalsIgnoreCase(version)).findFirst();
    }

    @Generated
    private HttpVersion(String version) {
        this.version = version;
    }
}

