/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest;

import de.gematik.bbriccs.rest.HttpHeaderKey;
import de.gematik.bbriccs.rest.HttpVersion;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.StandardHttpHeaderKey;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

interface HttpBEntity {
    public HttpVersion version();

    public List<HttpHeader> headers();

    public byte[] body();

    default public boolean isEmptyBody() {
        return this.body().length == 0;
    }

    default public String bodyAsString() {
        if (this.isEmptyBody()) {
            return "";
        }
        return new String(this.body(), StandardCharsets.UTF_8);
    }

    default public String contentType() {
        return this.headerValue(StandardHttpHeaderKey.CONTENT_TYPE);
    }

    default public int contentLength() {
        String clValue = this.headerValue(StandardHttpHeaderKey.CONTENT_LENGTH);
        if (clValue.isEmpty() || clValue.isBlank()) {
            return 0;
        }
        return Integer.parseInt(clValue);
    }

    default public String headerValue(HttpHeaderKey key) {
        return this.headerValue(key.getKey());
    }

    default public String headerValue(String key) {
        return this.headers().stream().filter(h -> h.key().equalsIgnoreCase(key) && h.value() != null).map(HttpHeader::value).findFirst().orElse("");
    }

    default public boolean hasHeader(HttpHeaderKey key) {
        return this.hasHeader(key.getKey());
    }

    default public boolean hasHeader(String key) {
        String value = this.headerValue(key);
        return StringUtils.isNotBlank((CharSequence)value);
    }
}

