/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest.plugins;

import de.gematik.bbriccs.rest.HttpBRequest;
import de.gematik.bbriccs.rest.HttpBResponse;
import de.gematik.bbriccs.rest.HttpRequestMethod;
import de.gematik.bbriccs.rest.plugins.HttpBObserver;
import de.gematik.bbriccs.rest.plugins.HttpBRequestObserver;
import de.gematik.bbriccs.rest.plugins.HttpBResponseObserver;
import de.gematik.bbriccs.rest.plugins.RestObserverManager;
import java.text.MessageFormat;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RestObserverManagerTest {
    RestObserverManagerTest() {
    }

    @Test
    void shouldNotifyRequestObservers() {
        TestObserver observer = new TestObserver();
        RestObserverManager observerManager = new RestObserverManager.RestObserverBuilder().registerForResponses((HttpBResponseObserver)observer).registerForRequests((HttpBRequestObserver)observer).build();
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.GET, "test");
        HttpBResponse response = new HttpBResponse(200, List.of(), "");
        observerManager.serveRequestObservers(request);
        observerManager.serveResponseObservers(response);
        Assertions.assertEquals((int)1, (int)observer.requestCount);
        Assertions.assertEquals((int)1, (int)observer.responseCount);
    }

    @Test
    void shouldNotServeIfNotRegistered() {
        TestObserver observer = new TestObserver();
        RestObserverManager observerManager = new RestObserverManager.RestObserverBuilder().build();
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.GET, "test");
        HttpBResponse response = new HttpBResponse(200, List.of(), "");
        observerManager.serveRequestObservers(request);
        observerManager.serveResponseObservers(response);
        Assertions.assertEquals((int)200, (int)response.statusCode());
        Assertions.assertTrue((boolean)response.isEmptyBody());
        System.out.println(MessageFormat.format("Spend some time to serve observers for response {0}", response.statusCode()));
        Assertions.assertEquals((int)0, (int)observer.requestCount);
        Assertions.assertEquals((int)0, (int)observer.responseCount);
    }

    private static class TestObserver
    implements HttpBObserver {
        private int requestCount = 0;
        private int responseCount = 0;

        private TestObserver() {
        }

        public void onRequest(HttpBRequest request) {
            ++this.requestCount;
        }

        public void onResponse(HttpBResponse response) {
            ++this.responseCount;
        }
    }
}

