/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest;

import de.gematik.bbriccs.rest.HttpBResponse;
import de.gematik.bbriccs.rest.HttpHeaderKey;
import de.gematik.bbriccs.rest.HttpVersion;
import de.gematik.bbriccs.rest.headers.HttpHeader;
import de.gematik.bbriccs.rest.headers.StandardHttpHeaderKey;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;

class HttpBResponseTest {
    HttpBResponseTest() {
    }

    @Test
    void shouldNotThrowOnNullResponse01() {
        String nullBody = null;
        HttpBResponse response = new HttpBResponse(200, List.of(StandardHttpHeaderKey.USER_AGENT.createHeader(" "), StandardHttpHeaderKey.ACCEPT.createHeader(null)), nullBody);
        Assertions.assertNotNull((Object)response.body());
        Assertions.assertEquals((int)0, (int)response.body().length);
        Assertions.assertTrue((boolean)response.isEmptyBody());
        Assertions.assertEquals((Object)"", (Object)response.bodyAsString());
        Assertions.assertFalse((boolean)response.hasHeader((HttpHeaderKey)StandardHttpHeaderKey.CONTENT_TYPE));
        Assertions.assertFalse((boolean)response.hasHeader((HttpHeaderKey)StandardHttpHeaderKey.USER_AGENT));
        Assertions.assertFalse((boolean)response.hasHeader((HttpHeaderKey)StandardHttpHeaderKey.ACCEPT));
    }

    @Test
    void shouldNotThrowOnNullResponse02() {
        String nullBody = null;
        HttpBResponse response = new HttpBResponse(HttpVersion.HTTP_1_1, 200, List.of(), nullBody);
        Assertions.assertNotNull((Object)response.body());
        Assertions.assertEquals((int)0, (int)response.body().length);
        Assertions.assertTrue((boolean)response.isEmptyBody());
        Assertions.assertEquals((Object)"", (Object)response.bodyAsString());
        Assertions.assertFalse((boolean)response.hasHeader((HttpHeaderKey)StandardHttpHeaderKey.CONTENT_TYPE));
    }

    @Test
    void shouldNotThrowOnNullResponse03() {
        byte[] nullBody = null;
        HttpBResponse response = new HttpBResponse(HttpVersion.HTTP_1_1, 200, List.of(), nullBody);
        Assertions.assertNotNull((Object)response.body());
        Assertions.assertEquals((int)0, (int)response.body().length);
        Assertions.assertTrue((boolean)response.isEmptyBody());
        Assertions.assertEquals((Object)"", (Object)response.bodyAsString());
        Assertions.assertFalse((boolean)response.hasHeader((HttpHeaderKey)StandardHttpHeaderKey.CONTENT_TYPE));
    }

    @Test
    void shouldNotThrowOnNullResponseWithoutBody() {
        HttpBResponse response = new HttpBResponse(200, List.of());
        Assertions.assertNotNull((Object)response.body());
        Assertions.assertEquals((int)0, (int)response.body().length);
        Assertions.assertTrue((boolean)response.isEmptyBody());
        Assertions.assertEquals((Object)"", (Object)response.bodyAsString());
        Assertions.assertFalse((boolean)response.hasHeader((HttpHeaderKey)StandardHttpHeaderKey.CONTENT_TYPE));
    }

    @Test
    void shouldNotThrowOnEmptyBody01() {
        byte[] emptyBody = new byte[]{};
        HttpBResponse response = new HttpBResponse(200, List.of(), emptyBody);
        Assertions.assertNotNull((Object)response.body());
        Assertions.assertTrue((boolean)response.isEmptyBody());
        Assertions.assertEquals((Object)"", (Object)response.bodyAsString());
    }

    @Test
    void shouldNotThrowOnEmptyBody02() {
        byte[] emptyBody = new byte[]{};
        HttpBResponse response = new HttpBResponse(HttpVersion.HTTP_2, 200, List.of(), emptyBody);
        Assertions.assertNotNull((Object)response.body());
        Assertions.assertTrue((boolean)response.isEmptyBody());
        Assertions.assertEquals((Object)"", (Object)response.bodyAsString());
    }

    @Test
    void shouldDecodeBodyAsUtf8String() {
        HttpBResponse response = new HttpBResponse(HttpVersion.HTTP_2, 200, List.of(), "HelloWorld".getBytes(StandardCharsets.UTF_8));
        Assertions.assertNotNull((Object)response.body());
        Assertions.assertFalse((boolean)response.isEmptyBody());
        Assertions.assertEquals((Object)"HelloWorld", (Object)response.bodyAsString());
    }

    @Test
    void shouldNotThrowOnMissingContentType() {
        HttpBResponse response = new HttpBResponse(HttpVersion.HTTP_1_1, 200, List.of(), "HelloWorld".getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"", (Object)response.contentType());
    }

    @ParameterizedTest
    @MethodSource
    void shouldNeverThrowOnMissingContentLength(HttpHeader contentLengthHeader) {
        HttpBResponse response = new HttpBResponse(HttpVersion.HTTP_1_1, 200, List.of(contentLengthHeader), "HelloWorld".getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((int)0, (int)response.contentLength());
    }

    static Stream<Arguments> shouldNeverThrowOnMissingContentLength() {
        return Stream.of(StandardHttpHeaderKey.CONTENT_LENGTH.createHeader("0"), StandardHttpHeaderKey.CONTENT_LENGTH.createHeader("-0"), StandardHttpHeaderKey.CONTENT_LENGTH.createHeader("00"), StandardHttpHeaderKey.CONTENT_LENGTH.createHeader(""), StandardHttpHeaderKey.CONTENT_LENGTH.createHeader("  "), StandardHttpHeaderKey.CONTENT_LENGTH.createHeader("\t"), StandardHttpHeaderKey.CONTENT_TYPE.createHeader("text/plain")).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldThrowOnInvalidContentLengthValue(HttpHeader contentLengthHeader) {
        HttpBResponse response = new HttpBResponse(HttpVersion.HTTP_1_1, 200, List.of(contentLengthHeader), "HelloWorld".getBytes(StandardCharsets.UTF_8));
        Assertions.assertThrows(NumberFormatException.class, () -> ((HttpBResponse)response).contentLength());
    }

    static Stream<Arguments> shouldThrowOnInvalidContentLengthValue() {
        return Stream.of(StandardHttpHeaderKey.CONTENT_LENGTH.createHeader("zero"), StandardHttpHeaderKey.CONTENT_LENGTH.createHeader("null")).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @ValueSource(strings={"", " ", "\t", "\n", "\r", "\n\r"})
    @NullSource
    void shouldReturnZeroOnEmptyContentLength(String clValue) {
        HttpBResponse response = new HttpBResponse(HttpVersion.HTTP_1_1, 200, List.of(StandardHttpHeaderKey.CONTENT_LENGTH.createHeader(clValue)), "HelloWorld".getBytes(StandardCharsets.UTF_8));
        Assertions.assertFalse((boolean)response.hasHeader((HttpHeaderKey)StandardHttpHeaderKey.CONTENT_LENGTH));
        Assertions.assertEquals((int)0, (int)response.contentLength());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 100, 1000, -10})
    void shouldReturnContentLengthFromHeader(int clValue) {
        HttpBResponse response = new HttpBResponse(HttpVersion.HTTP_1_1, 200, List.of(new HttpHeader("Content-Length", String.valueOf(clValue))));
        Assertions.assertEquals((int)clValue, (int)response.contentLength());
    }

    @Test
    void shouldThrowOnInvalidContentLength() {
        HttpBResponse response = new HttpBResponse(HttpVersion.HTTP_1_1, 200, List.of(new HttpHeader("Content-Length", "Not-A-Number")), "HelloWorld".getBytes(StandardCharsets.UTF_8));
        Assertions.assertThrows(NumberFormatException.class, () -> ((HttpBResponse)response).contentLength());
    }

    @Test
    void shouldAllowEmptyBody() {
        List headers = List.of();
        HttpBResponse response = (HttpBResponse)Assertions.assertDoesNotThrow(() -> new HttpBResponse(HttpVersion.HTTP_1_1, 200, headers));
        Assertions.assertTrue((boolean)response.isEmptyBody());
    }

    @Test
    void shouldAllowBodyAsString() {
        String body = "Hello World";
        List headers = List.of();
        HttpBResponse response = (HttpBResponse)Assertions.assertDoesNotThrow(() -> new HttpBResponse(HttpVersion.HTTP_1_1, 200, headers, "Hello World"));
        Assertions.assertFalse((boolean)response.isEmptyBody());
    }
}

