/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.rest;

import de.gematik.bbriccs.rest.HttpBRequest;
import de.gematik.bbriccs.rest.HttpRequestMethod;
import de.gematik.bbriccs.rest.HttpVersion;
import de.gematik.bbriccs.rest.headers.JwtHeaderKey;
import de.gematik.bbriccs.rest.headers.StandardHttpHeaderKey;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HttpBRequestTest {
    HttpBRequestTest() {
    }

    @Test
    void shouldNotThrowOnNullBody01() {
        byte[] nullBody = null;
        HttpBRequest request = new HttpBRequest(HttpVersion.HTTP_1_1, HttpRequestMethod.GET, "a/b/c", List.of(), nullBody);
        Assertions.assertNotNull((Object)request.body());
        Assertions.assertEquals((int)0, (int)request.body().length);
        Assertions.assertTrue((boolean)request.isEmptyBody());
        Assertions.assertEquals((Object)"", (Object)request.bodyAsString());
    }

    @Test
    void shouldNotThrowOnNullBody02() {
        String nullBody = null;
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.GET, "a/b/c", nullBody);
        Assertions.assertNotNull((Object)request.body());
        Assertions.assertEquals((int)0, (int)request.body().length);
        Assertions.assertTrue((boolean)request.isEmptyBody());
        Assertions.assertEquals((Object)"", (Object)request.bodyAsString());
    }

    @Test
    void shouldNotThrowOnEmptyBody() {
        byte[] emptyBody = new byte[]{};
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.GET, "a/b/c", emptyBody);
        Assertions.assertNotNull((Object)request.body());
        Assertions.assertTrue((boolean)request.isEmptyBody());
        Assertions.assertEquals((Object)"", (Object)request.bodyAsString());
    }

    @Test
    void shouldNotThrowOnEmptyBody02() {
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.GET, "a/b/c", StandardHttpHeaderKey.USER_AGENT.createHeader("bbriccs"), "");
        Assertions.assertNotNull((Object)request.body());
        Assertions.assertTrue((boolean)request.isEmptyBody());
        Assertions.assertEquals((Object)"", (Object)request.bodyAsString());
    }

    @Test
    void shouldEncodeBodyAsString() {
        String body = "HelloWorld";
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.GET, "a/b/c", List.of(), "HelloWorld");
        Assertions.assertNotNull((Object)request.body());
        Assertions.assertFalse((boolean)request.isEmptyBody());
        Assertions.assertEquals((Object)"HelloWorld", (Object)request.bodyAsString());
        Assertions.assertTrue((boolean)request.getBearerToken().isEmpty());
    }

    @Test
    void shouldExtractBearerToken() {
        byte[] body = "HelloWorld".getBytes(StandardCharsets.UTF_8);
        HttpBRequest request = new HttpBRequest(HttpRequestMethod.GET, "a/b/c", JwtHeaderKey.AUTHORIZATION.createHeader("ABC"), body);
        Optional bearer = request.getBearerToken();
        Assertions.assertTrue((boolean)bearer.isPresent());
        Assertions.assertEquals((Object)"ABC", bearer.get());
    }
}

