/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.utils;

import de.gematik.bbriccs.utils.PrivateConstructorsUtil;
import de.gematik.bbriccs.utils.ResourceFileException;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ResourceLoaderTest {
    ResourceLoaderTest() {
    }

    @Test
    void shouldNotHaveCallableConstructor() {
        Assertions.assertTrue((boolean)PrivateConstructorsUtil.isUtilityConstructor(ResourceLoader.class));
    }

    @Test
    void shouldReadSingleFile() {
        String content = ResourceLoader.readFileFromResource((String)"txt/first.txt");
        Assertions.assertEquals((Object)"First", (Object)content);
    }

    @Test
    void shouldGetFileFromResource() {
        File file = ResourceLoader.getFileFromResource((String)"txt/first.txt");
        Assertions.assertEquals((Object)"first.txt", (Object)file.getName());
    }

    @Test
    void shouldThrowOnGettingMissingFile() {
        ResourceFileException exception = (ResourceFileException)Assertions.assertThrows(ResourceFileException.class, () -> ResourceLoader.getFileFromResource((String)"txt/test_123.txt"));
        Assertions.assertTrue((boolean)exception.getMessage().contains("txt/test_123.txt"));
    }

    @Test
    void shouldThrowOnMissingFile() {
        ResourceFileException exception = (ResourceFileException)Assertions.assertThrows(ResourceFileException.class, () -> ResourceLoader.readFileFromResource((String)"txt/test_123.txt"));
        Assertions.assertTrue((boolean)exception.getMessage().contains("txt/test_123.txt not found in resources"));
    }

    @Test
    void shouldReadAllFilesFromDirectory() {
        List fileContents = (List)Assertions.assertDoesNotThrow(() -> ResourceLoader.readFilesFromDirectory((String)"txt"));
        Assertions.assertEquals((int)2, (int)fileContents.size());
        Assertions.assertTrue((boolean)fileContents.contains("First"));
        Assertions.assertTrue((boolean)fileContents.contains("Second"));
    }

    @Test
    void shouldGetAllFilesFromDirectory() {
        List files = (List)Assertions.assertDoesNotThrow(() -> ResourceLoader.getResourceFilesInDirectory((String)"txt"));
        Assertions.assertEquals((int)2, (int)files.size());
        List<String> fileNames = files.stream().map(File::getName).toList();
        Assertions.assertTrue((boolean)fileNames.contains("first.txt"));
        Assertions.assertTrue((boolean)fileNames.contains("second.txt"));
    }

    @Test
    void shouldReadAllFilesFromDirectoryRecursively() {
        List fileContents = (List)Assertions.assertDoesNotThrow(() -> ResourceLoader.readFilesFromDirectory((String)"txt", (boolean)true));
        Assertions.assertEquals((int)4, (int)fileContents.size());
        Assertions.assertTrue((boolean)fileContents.contains("Third"));
        Assertions.assertTrue((boolean)fileContents.contains("Fourth"));
    }

    @Test
    void shouldGetAllFilesFromDirectoryRecursively() {
        List files = (List)Assertions.assertDoesNotThrow(() -> ResourceLoader.getResourceFilesInDirectory((String)"txt", (boolean)true));
        Assertions.assertEquals((int)4, (int)files.size());
        List<String> fileNames = files.stream().map(File::getName).toList();
        Assertions.assertTrue((boolean)fileNames.contains("third.txt"));
        Assertions.assertTrue((boolean)fileNames.contains("fourth.txt"));
    }

    @Test
    void shouldGetCompleteDirectoryStructure() {
        List dirStructure = ResourceLoader.getResourceDirectoryStructure((String)"txt");
        Assertions.assertEquals((int)5, (int)dirStructure.size());
        List<File> dirs = dirStructure.stream().filter(File::isDirectory).toList();
        Assertions.assertEquals((int)1, (int)dirs.size());
        List<File> files = dirStructure.stream().filter(File::isFile).toList();
        Assertions.assertEquals((int)4, (int)files.size());
    }

    @Test
    void shouldGetCompleteDirectoryStructureOnLeaf() {
        List dirStructure = ResourceLoader.getResourceDirectoryStructure((String)"txt/subdir");
        Assertions.assertEquals((int)2, (int)dirStructure.size());
        List<File> dirs = dirStructure.stream().filter(File::isDirectory).toList();
        Assertions.assertEquals((int)0, (int)dirs.size());
        List<File> files = dirStructure.stream().filter(File::isFile).toList();
        Assertions.assertEquals((int)2, (int)files.size());
    }

    @Test
    void shouldReadEmptyDirectoryWithoutThrowing() throws IOException {
        Path basePath = Paths.get(this.getClass().getResource("/").getPath(), new String[0]);
        File emptyDir = basePath.resolve("empty").toFile();
        Files.createDirectories(emptyDir.toPath(), new FileAttribute[0]);
        List dirStructure = ResourceLoader.getResourceDirectoryStructure((String)"empty");
        Assertions.assertEquals((int)0, (int)dirStructure.size());
        List<File> dirs = dirStructure.stream().filter(File::isDirectory).toList();
        Assertions.assertEquals((int)0, (int)dirs.size());
        List<File> files = dirStructure.stream().filter(File::isFile).toList();
        Assertions.assertEquals((int)0, (int)files.size());
    }

    @Test
    void shouldThrowOnInvalidFileRead() {
        File f = Path.of("a/b/c", new String[0]).toFile();
        ResourceFileException exception = (ResourceFileException)Assertions.assertThrows(ResourceFileException.class, () -> ResourceLoader.readString((File)f));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Error while reading from file"));
        Assertions.assertTrue((boolean)exception.getMessage().contains("a/b/c"));
    }
}

