/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.utils;

import de.gematik.bbriccs.utils.ResourceFileException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceLoader.class);
    private static final ClassLoader CLASS_LOADER = ResourceLoader.class.getClassLoader();

    private ResourceLoader() {
        throw new IllegalAccessError("Utility class: don't use the constructor");
    }

    public static InputStream getFileFromResourceAsStream(String fileName) {
        InputStream inputStream = CLASS_LOADER.getResourceAsStream(fileName);
        if (inputStream == null) {
            throw new ResourceFileException(MessageFormat.format("File {0} not found in resources!", fileName));
        }
        return inputStream;
    }

    public static String readFileFromResource(String fileName) {
        InputStream stream = ResourceLoader.getFileFromResourceAsStream(fileName);
        return new String(stream.readAllBytes(), StandardCharsets.UTF_8);
    }

    public static File getFileFromResource(String fileName) {
        String resourceFileName = Objects.requireNonNull(CLASS_LOADER.getResource(fileName)).getFile();
        return Path.of(resourceFileName, new String[0]).toFile();
    }

    public static List<String> readFilesFromDirectory(String path) {
        return ResourceLoader.readFilesFromDirectory(path, false);
    }

    public static List<String> readFilesFromDirectory(String path, boolean recursive) {
        return ResourceLoader.getResourceFilesInDirectory(path, recursive).stream().map(ResourceLoader::readString).toList();
    }

    public static List<File> getResourceFilesInDirectory(String path) {
        return ResourceLoader.getResourceFilesInDirectory(path, false);
    }

    public static List<File> getResourceFilesInDirectory(String path, boolean recursive) {
        Path dir = ResourceLoader.toExistingResourceDirectoryPath(path);
        int maxDepth = recursive ? Integer.MAX_VALUE : 1;
        try (Stream<Path> walker = ResourceLoader.getFileWalker(dir, maxDepth);){
            List<File> list = walker.map(Path::toFile).toList();
            return list;
        }
    }

    @Generated
    private static Stream<Path> getFileWalker(Path path, int maxDepth) {
        return Files.find(path, maxDepth, (filePath, fileAttr) -> fileAttr.isRegularFile(), new FileVisitOption[0]);
    }

    public static List<File> getResourceDirectoryStructure(String path) {
        return ResourceLoader.getResourceDirectoryStructure(path, true);
    }

    public static List<File> getResourceDirectoryStructure(String path, boolean recursive) {
        List<File> list;
        block8: {
            Path dir = ResourceLoader.toExistingResourceDirectoryPath(path);
            int maxDepth = recursive ? Integer.MAX_VALUE : 1;
            Stream<Path> walker = Files.find(dir, maxDepth, (filePath, fileAttr) -> fileAttr.isRegularFile() || fileAttr.isDirectory(), new FileVisitOption[0]);
            try {
                list = walker.filter(p -> !p.equals(dir)).map(Path::toFile).toList();
                if (walker == null) break block8;
            }
            catch (Throwable throwable) {
                if (walker != null) {
                    try {
                        walker.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            walker.close();
        }
        return list;
    }

    public static String readString(File file) {
        try {
            return Files.readString(Path.of(file.getAbsolutePath(), new String[0]));
        }
        catch (IOException e) {
            throw new ResourceFileException(MessageFormat.format("Error while reading from file {0}", file.getAbsolutePath()));
        }
    }

    private static Path toExistingResourceDirectoryPath(String path) {
        URI pathUrl = Objects.requireNonNull(CLASS_LOADER.getResource(path), MessageFormat.format("Unable to read file from {0}", path)).toURI();
        Path dir = Path.of(pathUrl);
        File file = dir.toFile();
        if (!file.exists() || !file.isDirectory()) {
            throw new ResourceFileException(MessageFormat.format("Given path {0} does not exist or is not a directory", path));
        }
        return dir;
    }
}

