/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.utils;

import de.gematik.bbriccs.utils.PrivateConstructorsUtil;
import de.gematik.bbriccs.utils.ResourceFileException;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class ResourceLoaderTest {
    ResourceLoaderTest() {
    }

    @Test
    void shouldNotHaveCallableConstructor() {
        Assertions.assertTrue((boolean)PrivateConstructorsUtil.isUtilityConstructor(ResourceLoader.class));
    }

    @Test
    void shouldReadSingleFile() {
        String content = ResourceLoader.readFileFromResource((String)"txt/first.txt");
        Assertions.assertEquals((Object)"First", (Object)content);
    }

    @Test
    void shouldGetFileFromResource() {
        File file = ResourceLoader.getFileFromResource((String)"txt/first.txt");
        Assertions.assertEquals((Object)"first.txt", (Object)file.getName());
    }

    @Test
    void shouldThrowOnMissingFile() {
        ResourceFileException exception = (ResourceFileException)Assertions.assertThrows(ResourceFileException.class, () -> ResourceLoader.readFileFromResource((String)"txt/test_123.txt"));
        Assertions.assertTrue((boolean)exception.getMessage().contains("txt/test_123.txt not found in resources"));
    }

    @Test
    void shouldReadAllFilesFromDirectory() {
        List fileContents = (List)Assertions.assertDoesNotThrow(() -> ResourceLoader.readFilesFromDirectory((String)"txt"));
        Assertions.assertEquals((int)2, (int)fileContents.size());
        Assertions.assertTrue((boolean)fileContents.contains("First"));
        Assertions.assertTrue((boolean)fileContents.contains("Second"));
    }

    @Test
    void shouldGetAllFilesFromDirectory() {
        List files = (List)Assertions.assertDoesNotThrow(() -> ResourceLoader.getResourceFilesInDirectory((String)"txt"));
        Assertions.assertEquals((int)2, (int)files.size());
        List<String> fileNames = files.stream().map(File::getName).toList();
        Assertions.assertTrue((boolean)fileNames.contains("first.txt"));
        Assertions.assertTrue((boolean)fileNames.contains("second.txt"));
    }

    @Test
    void shouldReadAllFilesFromDirectoryRecursively() {
        List fileContents = (List)Assertions.assertDoesNotThrow(() -> ResourceLoader.readFilesFromDirectory((String)"txt", (boolean)true));
        Assertions.assertEquals((int)4, (int)fileContents.size());
        Assertions.assertTrue((boolean)fileContents.contains("Third"));
        Assertions.assertTrue((boolean)fileContents.contains("Fourth"));
    }

    @Test
    void shouldGetAllFilesFromDirectoryRecursively() {
        List files = (List)Assertions.assertDoesNotThrow(() -> ResourceLoader.getResourceFilesInDirectory((String)"txt", (boolean)true));
        Assertions.assertEquals((int)4, (int)files.size());
        List<String> fileNames = files.stream().map(File::getName).toList();
        Assertions.assertTrue((boolean)fileNames.contains("third.txt"));
        Assertions.assertTrue((boolean)fileNames.contains("fourth.txt"));
    }

    @Test
    void shouldGetCompleteDirectoryStructure() {
        List dirStructure = ResourceLoader.getResourceDirectoryStructure((String)"txt");
        Assertions.assertEquals((int)5, (int)dirStructure.size());
        List<File> dirs = dirStructure.stream().filter(File::isDirectory).toList();
        Assertions.assertEquals((int)1, (int)dirs.size());
        List<File> files = dirStructure.stream().filter(File::isFile).toList();
        Assertions.assertEquals((int)4, (int)files.size());
    }

    @Test
    void shouldGetCompleteDirectoryStructureOnLeaf() {
        List dirStructure = ResourceLoader.getResourceDirectoryStructure((String)"txt/subdir");
        Assertions.assertEquals((int)2, (int)dirStructure.size());
        List<File> dirs = dirStructure.stream().filter(File::isDirectory).toList();
        Assertions.assertEquals((int)0, (int)dirs.size());
        List<File> files = dirStructure.stream().filter(File::isFile).toList();
        Assertions.assertEquals((int)2, (int)files.size());
    }

    @Test
    void shouldSneakyThrowOnIOException() {
        String dir = "txt";
        File pathFile = ((File)ResourceLoader.getResourceFilesInDirectory((String)"txt").get(0)).getParentFile();
        Path path = Path.of(pathFile.getAbsolutePath(), new String[0]);
        try (MockedStatic filesMock = Mockito.mockStatic(Files.class);){
            filesMock.when(() -> Files.find((Path)Mockito.eq((Object)path), Mockito.anyInt(), (BiPredicate)Mockito.any(BiPredicate.class), new FileVisitOption[0])).thenThrow(new Throwable[]{new IOException("example error")});
            IOException exception = (IOException)Assertions.assertThrows(IOException.class, () -> ResourceLoader.getResourceDirectoryStructure((String)"txt", (boolean)false));
            Assertions.assertEquals((Object)"example error", (Object)exception.getMessage());
        }
    }

    @Test
    void shouldThrowOnInvalidFileRead() {
        File f = Path.of("a/b/c", new String[0]).toFile();
        ResourceFileException exception = (ResourceFileException)Assertions.assertThrows(ResourceFileException.class, () -> ResourceLoader.readString((File)f));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Error while reading from file"));
        Assertions.assertTrue((boolean)exception.getMessage().contains("a/b/c"));
    }

    @ParameterizedTest
    @MethodSource
    void shouldThrowOnNonExistingResourceDirectoryPath(boolean exists, boolean isDirectory) {
        try (MockedStatic sp = Mockito.mockStatic(Path.class);){
            File mockFile = (File)Mockito.mock(File.class);
            Path mockPath = (Path)Mockito.mock(Path.class);
            Mockito.when((Object)mockPath.toFile()).thenReturn((Object)mockFile);
            Mockito.when((Object)mockFile.exists()).thenReturn((Object)exists);
            Mockito.when((Object)mockFile.isDirectory()).thenReturn((Object)isDirectory);
            sp.when(() -> Path.of((URI)Mockito.any(URI.class))).thenReturn((Object)mockPath);
            ResourceFileException exception = (ResourceFileException)Assertions.assertThrows(ResourceFileException.class, () -> ResourceLoader.getResourceDirectoryStructure((String)"txt"));
            Assertions.assertEquals((Object)"Given path txt does not exist or is not a directory", (Object)exception.getMessage());
        }
    }

    public static Stream<Arguments> shouldThrowOnNonExistingResourceDirectoryPath() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{true, false}), Arguments.arguments((Object[])new Object[]{false, true}));
    }
}

