/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.cfg.dto.TLSConfiguration;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrustProvider.class);
    private final KeyManager[] keyManagers;
    private final X509TrustManager[] trustManagers;

    private TrustProvider(KeyManager[] keyManagers, X509TrustManager[] trustManagers) {
        this.keyManagers = keyManagers;
        this.trustManagers = trustManagers;
        log.trace(MessageFormat.format("Created {0} with {1} KeyManagers and {2} TrustManagers", this.getClass().getSimpleName(), keyManagers.length, trustManagers.length));
    }

    public static TrustProvider from(TLSConfiguration cfg) {
        String keyStorePassword = cfg.getKeyStorePassword();
        String keyStoreFile = cfg.getKeyStore();
        String trustStorePassword = cfg.getTrustStorePassword();
        String trustStoreFile = cfg.getTrustStore();
        return TrustProvider.from(keyStoreFile, keyStorePassword, trustStoreFile, trustStorePassword);
    }

    public static TrustProvider from(String ksf, String ksp, String tsf, String tsp) {
        log.trace(MessageFormat.format("Create KeyManager from {0} and TrustManager from {1}", ksf, tsf));
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        KeyStore keyStore = KeyStore.getInstance(TrustProvider.keyStoreTypeFromFilename(ksf));
        Path keyStoreFilename = Path.of(ksf, new String[0]);
        InputStream keyStoreInputStream = ClassLoader.getSystemResourceAsStream(keyStoreFilename.toString());
        keyStore.load(keyStoreInputStream, ksp.toCharArray());
        keyManagerFactory.init(keyStore, ksp.toCharArray());
        Path trustStoreFilename = Path.of(tsf, new String[0]);
        InputStream trustStoreInputStream = ClassLoader.getSystemResourceAsStream(trustStoreFilename.toString());
        KeyStore trustStore = KeyStore.getInstance(TrustProvider.keyStoreTypeFromFilename(tsf));
        trustStore.load(trustStoreInputStream, tsp.toCharArray());
        TrustManagerFactory konnektorTrustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        konnektorTrustManagerFactory.init(trustStore);
        X509TrustManager konnektorTrustManager = TrustProvider.findX509TrustManager(konnektorTrustManagerFactory.getTrustManagers());
        X509TrustManager[] trustManagers = new X509TrustManager[]{new KonnektorTrustManager(konnektorTrustManager)};
        return new TrustProvider(keyManagerFactory.getKeyManagers(), trustManagers);
    }

    private static X509TrustManager findX509TrustManager(TrustManager[] all) {
        return Arrays.stream(all).filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).findFirst().orElseThrow();
    }

    private static String keyStoreTypeFromFilename(String filename) {
        String type = "INVALID";
        if (filename.endsWith("p12") || filename.endsWith("pfx")) {
            type = "PKCS12";
        } else if (filename.endsWith("jks")) {
            type = "JKS";
        }
        return type;
    }

    public SSLSocketFactory getSocketFactory() {
        SSLContext sslctx = SSLContext.getInstance("TLSv1.2");
        sslctx.init(this.keyManagers, this.trustManagers, new SecureRandom());
        return sslctx.getSocketFactory();
    }

    private static class KonnektorTrustManager
    implements X509TrustManager {
        private final X509TrustManager[] trustmanagers;

        public KonnektorTrustManager(X509TrustManager ... m) {
            this.trustmanagers = m;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (X509TrustManager tm : this.trustmanagers) {
                tm.checkServerTrusted(chain, authType);
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            for (X509TrustManager tm : this.trustmanagers) {
                tm.checkServerTrusted(chain, authType);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustmanagers[0].getAcceptedIssuers();
        }
    }
}

