/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.cfg.dto.BasicAuthConfiguration;
import de.gematik.bbriccs.cfg.dto.TLSConfiguration;
import de.gematik.bbriccs.konnektor.KonnektorServiceDefinition;
import de.gematik.bbriccs.konnektor.ServicePort;
import de.gematik.bbriccs.konnektor.TrustProvider;
import de.gematik.ws.conn.authsignatureservice.wsdl.v7_4.AuthSignatureService;
import de.gematik.ws.conn.authsignatureservice.wsdl.v7_4.AuthSignatureServicePortType;
import de.gematik.ws.conn.cardservice.wsdl.v8.CardService;
import de.gematik.ws.conn.cardservice.wsdl.v8.CardServicePortType;
import de.gematik.ws.conn.cardterminalservice.wsdl.v1.CardTerminalService;
import de.gematik.ws.conn.cardterminalservice.wsdl.v1.CardTerminalServicePortType;
import de.gematik.ws.conn.certificateservice.wsdl.v6.CertificateService;
import de.gematik.ws.conn.certificateservice.wsdl.v6.CertificateServicePortType;
import de.gematik.ws.conn.encryptionservice.wsdl.v6.EncryptionService;
import de.gematik.ws.conn.encryptionservice.wsdl.v6.EncryptionServicePortType;
import de.gematik.ws.conn.eventservice.wsdl.v7.EventService;
import de.gematik.ws.conn.eventservice.wsdl.v7.EventServicePortType;
import de.gematik.ws.conn.servicedirectory.ConnectorServices;
import de.gematik.ws.conn.signatureservice.wsdl.v7.SignatureService;
import de.gematik.ws.conn.signatureservice.wsdl.v7.SignatureServicePortType;
import de.gematik.ws.conn.vsds.vsdservice.v5.VSDService;
import de.gematik.ws.conn.vsds.vsdservice.v5.VSDServicePortType;
import jakarta.annotation.Nullable;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.ws.BindingProvider;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteKonServicePort
extends ServicePort {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoteKonServicePort.class);
    private final URL baseUrl;
    @Nullable
    private final TrustProvider trustProvider;
    private final HostnameVerifier hostnameVerifier;
    @Nullable
    private final String username;
    @Nullable
    private final String password;

    private RemoteKonServicePort(Builder builder) {
        super(builder.sds);
        this.baseUrl = builder.baseUrl;
        this.trustProvider = builder.trustProvider;
        this.hostnameVerifier = builder.hostnameVerifier;
        this.username = builder.userName;
        this.password = builder.password;
    }

    public static Builder onRemote(String url) {
        return RemoteKonServicePort.onRemote(new URL(url));
    }

    public static Builder onRemote(URL baseUrl) {
        return new Builder(baseUrl);
    }

    public final SignatureServicePortType getSignatureService() {
        SignatureService service = new SignatureService();
        SignatureServicePortType servicePort = service.getSignatureServicePort();
        this.setEndpointAddress((BindingProvider)servicePort, this.getSds().getSignatureService());
        return servicePort;
    }

    public final AuthSignatureServicePortType getAuthSignatureService() {
        AuthSignatureService service = new AuthSignatureService();
        AuthSignatureServicePortType servicePort = service.getAuthSignatureServicePort();
        this.setEndpointAddress((BindingProvider)servicePort, this.getSds().getAuthSignatureService());
        return servicePort;
    }

    public final CertificateServicePortType getCertificateService() {
        CertificateService service = new CertificateService();
        CertificateServicePortType servicePort = service.getCertificateServicePort();
        this.setEndpointAddress((BindingProvider)servicePort, this.getSds().getCertificateService());
        return servicePort;
    }

    public final EventServicePortType getEventService() {
        EventService service = new EventService();
        EventServicePortType servicePort = service.getEventServicePort();
        this.setEndpointAddress((BindingProvider)servicePort, this.getSds().getEventService());
        return servicePort;
    }

    public final CardServicePortType getCardService() {
        CardService service = new CardService();
        CardServicePortType servicePort = service.getCardServicePort();
        this.setEndpointAddress((BindingProvider)servicePort, this.getSds().getCardService());
        return servicePort;
    }

    public final CardTerminalServicePortType getCardTerminalService() {
        CardTerminalService service = new CardTerminalService();
        CardTerminalServicePortType servicePort = service.getCardTerminalServicePort();
        this.setEndpointAddress((BindingProvider)servicePort, this.getSds().getEventService());
        return servicePort;
    }

    public VSDServicePortType getVSDServicePortType() {
        VSDService service = new VSDService();
        VSDServicePortType servicePort = service.getVSDServicePort();
        this.setEndpointAddress((BindingProvider)servicePort, this.getSds().getVsdService());
        return servicePort;
    }

    public EncryptionServicePortType getEncryptionServicePortType() {
        EncryptionService service = new EncryptionService();
        EncryptionServicePortType servicePort = service.getEncryptionServicePort();
        this.setEndpointAddress((BindingProvider)servicePort, this.getSds().getEncryptionService());
        return servicePort;
    }

    private void setEndpointAddress(BindingProvider servicePort, String path) {
        log.info("Prepare ServicePort {} for {}", (Object)servicePort, (Object)path);
        servicePort.getRequestContext().put("jakarta.xml.ws.service.endpoint.address", path);
        if (this.username != null) {
            servicePort.getRequestContext().put("jakarta.xml.ws.security.auth.username", this.username);
        }
        if (this.password != null) {
            servicePort.getRequestContext().put("jakarta.xml.ws.security.auth.password", this.password);
        }
        if (this.trustProvider != null) {
            servicePort.getRequestContext().put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", this.trustProvider.getSocketFactory());
            servicePort.getRequestContext().put("com.sun.xml.ws.transport.https.client.hostname.verifier", this.hostnameVerifier);
        }
    }

    public String toString() {
        return MessageFormat.format("{0} at {1}", this.getSds().getProductName(), this.baseUrl);
    }

    public static class Builder {
        private final URL baseUrl;
        private KonnektorServiceDefinition sds;
        private String userName;
        private String password;
        @Nullable
        private TrustProvider trustProvider;
        private HostnameVerifier hostnameVerifier = (hostname, session) -> true;

        private Builder(URL baseUrl) {
            this.baseUrl = baseUrl;
        }

        public Builder tls(TLSConfiguration tlsConfig) {
            Optional.ofNullable(tlsConfig).ifPresent(tls -> this.trustProvider(TrustProvider.from(tls)));
            return this;
        }

        public Builder auth(BasicAuthConfiguration auth) {
            Optional.ofNullable(auth).ifPresent(basicAuth -> this.auth(basicAuth.getUsername(), basicAuth.getPassword()));
            return this;
        }

        public Builder auth(String username, String password) {
            return this.username(username).password(password);
        }

        public Builder username(String username) {
            this.userName = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder trustProvider(TrustProvider trustProvider) {
            this.trustProvider = trustProvider;
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public RemoteKonServicePort build() {
            this.connect();
            return new RemoteKonServicePort(this);
        }

        private void connect() {
            HttpURLConnection con;
            String sdsUri = this.baseUrl.toURI().getPath() + "/connector.sds";
            URL sdsUrl = this.baseUrl.toURI().resolve(sdsUri).toURL();
            if (this.baseUrl.getProtocol().equalsIgnoreCase("https")) {
                Objects.requireNonNull(this.trustProvider, "HTTPS protocol without a TrustProvider given");
                HttpsURLConnection httpsCon = (HttpsURLConnection)sdsUrl.openConnection();
                httpsCon.setHostnameVerifier((arg0, arg1) -> true);
                httpsCon.setSSLSocketFactory(this.trustProvider.getSocketFactory());
                con = httpsCon;
            } else {
                con = (HttpURLConnection)sdsUrl.openConnection();
            }
            con.setRequestMethod("GET");
            con.connect();
            JAXBContext jaxb = JAXBContext.newInstance((Class[])new Class[]{ConnectorServices.class});
            Unmarshaller unmarshaller = jaxb.createUnmarshaller();
            ConnectorServices connectorServices = (ConnectorServices)unmarshaller.unmarshal((Reader)new BufferedReader(new InputStreamReader(con.getInputStream())));
            con.disconnect();
            this.sds = KonnektorServiceDefinition.from((ConnectorServices)connectorServices);
            log.info("connected to {} on {}", (Object)this.sds.getProductName(), (Object)this.baseUrl);
        }
    }
}

