/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit5.WireMockExtension;
import com.github.tomakehurst.wiremock.junit5.WireMockTest;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import de.gematik.bbriccs.cardterminal.CardTerminal;
import de.gematik.bbriccs.cats.cfg.CatsConfiguration;
import de.gematik.bbriccs.cfg.dto.TLSConfiguration;
import de.gematik.bbriccs.konnektor.KonnektorBuildInstruction;
import de.gematik.bbriccs.konnektor.RemoteKonFactory;
import de.gematik.bbriccs.konnektor.cfg.KonnektorConfiguration;
import de.gematik.bbriccs.konnektor.cfg.KonnektorContextConfiguration;
import de.gematik.bbriccs.konnektor.cfg.KonnektorServiceConfiguration;
import de.gematik.bbriccs.konnektor.cfg.RemoteKonServiceConfiguration;
import de.gematik.bbriccs.utils.ResourceLoader;
import java.net.MalformedURLException;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

@WireMockTest
class RemoteKonFactoryTest {
    @RegisterExtension
    static WireMockExtension wm1 = WireMockExtension.newInstance().options((Options)WireMockConfiguration.wireMockConfig().dynamicPort().dynamicHttpsPort()).build();
    private static String url;

    RemoteKonFactoryTest() {
    }

    @BeforeAll
    static void setup() {
        int port = wm1.getPort();
        url = "http://localhost:" + port;
    }

    private void prepareKonnektorSdsResponse() {
        String sds = ResourceLoader.readFileFromResource((String)"sds/cgm_connector_sds.xml");
        wm1.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/connector.sds")).willReturn(WireMock.aResponse().withBody(sds)));
    }

    @Test
    void shouldMapConfigToBuildInstruction() {
        this.prepareKonnektorSdsResponse();
        TLSConfiguration tlsCfg = new TLSConfiguration();
        tlsCfg.setKeyStore("resources/tls/keystore.p12");
        tlsCfg.setKeyStorePassword("changeit");
        tlsCfg.setTrustStore("resource/tls/truststore.p12");
        tlsCfg.setTrustStorePassword("123456");
        RemoteKonServiceConfiguration serviceCfg = new RemoteKonServiceConfiguration();
        serviceCfg.setAddress(url);
        serviceCfg.setTls(tlsCfg);
        KonnektorContextConfiguration ctx = KonnektorContextConfiguration.getDefaultContextConfiguration();
        CatsConfiguration ctCfg = new CatsConfiguration();
        ctCfg.setType("CATS");
        ctCfg.setCtId("ctId");
        ctCfg.setUrl(url);
        KonnektorConfiguration cfg = new KonnektorConfiguration();
        cfg.setService((KonnektorServiceConfiguration)serviceCfg);
        cfg.setContext(ctx);
        cfg.setCardTerminals(List.of(ctCfg));
        RemoteKonFactory factory = new RemoteKonFactory();
        KonnektorBuildInstruction bi = (KonnektorBuildInstruction)Assertions.assertDoesNotThrow(() -> factory.mapConfiguration(cfg));
        Assertions.assertNotNull((Object)bi.getCtx());
        Assertions.assertEquals((int)1, (int)bi.getCardTerminals().size());
        CardTerminal catsCt = (CardTerminal)Assertions.assertDoesNotThrow(() -> (CardTerminal)bi.getCardTerminals().stream().findFirst().orElseThrow());
        Assertions.assertEquals((Object)"ctId", (Object)catsCt.getCtId());
    }

    @Test
    void shouldReThrowOnInvalidUrl() {
        RemoteKonServiceConfiguration serviceCfg = new RemoteKonServiceConfiguration();
        serviceCfg.setAddress("abc");
        KonnektorConfiguration cfg = new KonnektorConfiguration();
        cfg.setService((KonnektorServiceConfiguration)serviceCfg);
        RemoteKonFactory factory = new RemoteKonFactory();
        Assertions.assertEquals((Object)"Remote-Kon", (Object)factory.getType());
        Assertions.assertThrows(MalformedURLException.class, () -> factory.mapConfiguration(cfg));
    }
}

