/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.cfg.dto.TLSConfiguration;
import de.gematik.bbriccs.konnektor.TrustProvider;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class TrustProviderTest {
    TrustProviderTest() {
    }

    static Stream<Arguments> shouldBuildFromConfig() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"resources/tls/keystore.p12", "resource/tls/truststore.p12"}), Arguments.arguments((Object[])new Object[]{"resources/tls/keystore.p12", "resource/tls/konsim_truststore.jks"}));
    }

    @ParameterizedTest
    @MethodSource
    void shouldBuildFromConfig(String keyStorePath, String trustStorePath) {
        TLSConfiguration cfg = new TLSConfiguration();
        cfg.setKeyStore(keyStorePath);
        cfg.setKeyStorePassword("changeit");
        cfg.setTrustStore(trustStorePath);
        cfg.setTrustStorePassword("123456");
        TrustProvider trustProvider = (TrustProvider)Assertions.assertDoesNotThrow(() -> TrustProvider.from((TLSConfiguration)cfg));
        Assertions.assertNotNull((Object)trustProvider.getSocketFactory());
    }
}

