/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.bbriccs.konnektor;

import de.gematik.bbriccs.cardterminal.CardTerminal;
import de.gematik.bbriccs.cardterminal.CardTerminalFactory;
import de.gematik.bbriccs.konnektor.KonnektorBuildInstruction;
import de.gematik.bbriccs.konnektor.KonnektorFactory;
import de.gematik.bbriccs.konnektor.RemoteKonServicePort;
import de.gematik.bbriccs.konnektor.ServicePort;
import de.gematik.bbriccs.konnektor.cfg.KonnektorConfiguration;
import de.gematik.bbriccs.konnektor.cfg.RemoteKonServiceConfiguration;
import java.net.URL;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteKonFactory
implements KonnektorFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoteKonFactory.class);
    public static final String SERVICE_NAME = "Remote-Kon";

    public String getType() {
        return SERVICE_NAME;
    }

    public KonnektorBuildInstruction mapConfiguration(KonnektorConfiguration cfg) {
        RemoteKonServiceConfiguration rkscdto = (RemoteKonServiceConfiguration)cfg.getService().castTo((KonnektorFactory)this, RemoteKonServiceConfiguration.class);
        log.info("Build Konnektor-Client {} for {}", (Object)cfg.getName(), (Object)rkscdto.getType());
        log.info("Connect to {} on {}", (Object)rkscdto.getType(), (Object)rkscdto.getAddress());
        URL url = new URL(rkscdto.getAddress());
        RemoteKonServicePort service = RemoteKonServicePort.onRemote(url).tls(rkscdto.getTls()).auth(rkscdto.getBasicAuth()).build();
        List<CardTerminal> cardTerminals = cfg.getCardTerminals().stream().map(CardTerminalFactory::create).toList();
        return KonnektorBuildInstruction.builder().ctx(cfg.getContext().asContextType()).serviceProvider((ServicePort)service).cardTerminals(cardTerminals).build();
    }
}

